/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.repository.Configurator;
import org.jboss.dna.repository.DnaConfigurationException;
import org.jboss.dna.repository.DnaEngine;
import org.jboss.dna.repository.DnaLexicon;
import org.jboss.dna.repository.sequencer.Sequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaConfiguration
implements Configurator.Initializer<DnaConfiguration>,
Configurator.SequencerConfigurator<DnaConfiguration>,
Configurator.RepositoryConfigurator<DnaConfiguration>,
Configurator.MimeDetectorConfigurator<DnaConfiguration>,
Configurator.Builder<DnaEngine> {
    protected static final Map<String, Name> NAMES_TO_MAP;
    private final Builder<DnaConfiguration> builder;

    public DnaConfiguration() {
        this(new ExecutionContext());
    }

    public DnaConfiguration(ExecutionContext context) {
        this.builder = new Builder<DnaConfiguration>(context, this);
    }

    public final ExecutionContext getExecutionContext() {
        return this.builder.getExecutionContext();
    }

    @Override
    public Configurator.ChooseClass<RepositorySource, Configurator.ConfigRepositoryDetails<DnaConfiguration>> withConfigurationRepository() {
        return this.builder.withConfigurationRepository();
    }

    @Override
    public Configurator.ChooseClass<RepositorySource, Configurator.RepositoryDetails<DnaConfiguration>> addRepository(String id) {
        return this.builder.addRepository(id);
    }

    @Override
    public DnaConfiguration addRepository(RepositorySource source) {
        return this.builder.addRepository(source);
    }

    @Override
    public Configurator.ChooseClass<Sequencer, Configurator.SequencerDetails<DnaConfiguration>> addSequencer(String id) {
        return this.builder.addSequencer(id);
    }

    @Override
    public Configurator.ChooseClass<MimeTypeDetector, Configurator.MimeTypeDetectorDetails<DnaConfiguration>> addMimeTypeDetector(String id) {
        return this.builder.addMimeTypeDetector(id);
    }

    public DnaConfiguration save() {
        return (DnaConfiguration)this.builder.save();
    }

    @Override
    public DnaEngine build() throws DnaConfigurationException {
        this.save();
        return new DnaEngine(this.builder.getExecutionContext(), this.builder.configurationSource);
    }

    protected Graph graph() {
        return this.builder.graph();
    }

    protected Configurator.ConfigurationRepository configurationRepository() {
        return this.builder.configurationSource;
    }

    static {
        HashMap<String, Name> names = new HashMap<String, Name>();
        names.put(DnaLexicon.READABLE_NAME.getLocalName(), DnaLexicon.READABLE_NAME);
        names.put(DnaLexicon.DESCRIPTION.getLocalName(), DnaLexicon.DESCRIPTION);
        names.put(DnaLexicon.DEFAULT_CACHE_POLICY.getLocalName(), DnaLexicon.DEFAULT_CACHE_POLICY);
        names.put(DnaLexicon.RETRY_LIMIT.getLocalName(), DnaLexicon.RETRY_LIMIT);
        names.put(DnaLexicon.PATH_EXPRESSIONS.getLocalName(), DnaLexicon.PATH_EXPRESSIONS);
        names.put(DnaLexicon.CLASSNAME.getLocalName(), DnaLexicon.CLASSNAME);
        names.put(DnaLexicon.CLASSPATH.getLocalName(), DnaLexicon.CLASSPATH);
        NAMES_TO_MAP = Collections.unmodifiableMap(names);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<ReturnType>
    extends Configurator<ReturnType>
    implements Configurator.Initializer<ReturnType>,
    Configurator.SequencerConfigurator<ReturnType>,
    Configurator.RepositoryConfigurator<ReturnType>,
    Configurator.MimeDetectorConfigurator<ReturnType> {
        private Path sourcesPath;
        private Path sequencersPath;
        private Path detectorsPath;

        public Builder(ExecutionContext context, ReturnType builder) {
            super(context, builder);
        }

        public DnaEngine buildDnaEngine() {
            return new DnaEngine(this.context, this.configurationSource);
        }

        public Configurator.ConfigurationRepository getConfigurationRepository() {
            return this.configurationSource;
        }

        protected Path sourcesPath() {
            if (this.sourcesPath == null) {
                Path path = this.pathFactory().create(this.configurationSource.getPath(), new Name[]{DnaLexicon.SOURCES});
                Node node = this.graph().createIfMissing(path).andReturn();
                this.sourcesPath = node.getLocation().getPath();
            }
            return this.sourcesPath;
        }

        protected Path sequencersPath() {
            if (this.sequencersPath == null) {
                Path path = this.pathFactory().create(this.configurationSource.getPath(), new Name[]{DnaLexicon.SEQUENCERS});
                Node node = this.graph().createIfMissing(path).andReturn();
                this.sequencersPath = node.getLocation().getPath();
            }
            return this.sequencersPath;
        }

        protected Path detectorsPath() {
            if (this.detectorsPath == null) {
                Path path = this.pathFactory().create(this.configurationSource.getPath(), new Name[]{DnaLexicon.MIME_TYPE_DETECTORS});
                Node node = this.graph().createIfMissing(path).andReturn();
                this.detectorsPath = node.getLocation().getPath();
            }
            return this.detectorsPath;
        }

        @Override
        public Configurator.ChooseClass<RepositorySource, Configurator.ConfigRepositoryDetails<ReturnType>> withConfigurationRepository() {
            return new Configurator.ConfigurationRepositoryClassChooser<Object>(this.builder);
        }

        @Override
        public Configurator.ChooseClass<Sequencer, Configurator.SequencerDetails<ReturnType>> addSequencer(String id) {
            CheckArg.isNotEmpty((String)id, (String)"id");
            Path path = this.createOrReplaceNode(this.sequencersPath(), id);
            Configurator.GraphSequencerDetails<Object> details = new Configurator.GraphSequencerDetails<Object>(path, this.builder);
            return new Configurator.ClassChooser<Sequencer, Configurator.SequencerDetails<ReturnType>>(path, details);
        }

        @Override
        public Configurator.ChooseClass<RepositorySource, Configurator.RepositoryDetails<ReturnType>> addRepository(String id) {
            CheckArg.isNotEmpty((String)id, (String)"id");
            Path path = this.createOrReplaceNode(this.sourcesPath(), id);
            Configurator.GraphRepositoryDetails<Object> details = new Configurator.GraphRepositoryDetails<Object>(path, this.builder);
            return new Configurator.ClassChooser<RepositorySource, Configurator.RepositoryDetails<ReturnType>>(path, details);
        }

        @Override
        public ReturnType addRepository(RepositorySource source) {
            CheckArg.isNotNull((Object)source, (String)"source");
            CheckArg.isNotEmpty((String)source.getName(), (String)"source.getName()");
            String name = source.getName();
            Configurator.RepositoryDetails<ReturnType> details = this.addRepository(source.getName()).usingClass(source.getClass().getName()).loadedFromClasspath();
            Path sourcePath = this.pathFactory().create(this.sourcesPath(), name);
            this.recordBeanPropertiesInGraph(sourcePath, source);
            return details.and();
        }

        @Override
        public Configurator.ChooseClass<MimeTypeDetector, Configurator.MimeTypeDetectorDetails<ReturnType>> addMimeTypeDetector(String id) {
            CheckArg.isNotEmpty((String)id, (String)"id");
            Path detectorPath = this.createOrReplaceNode(this.detectorsPath(), id);
            Configurator.GraphMimeTypeDetectorDetails<Object> details = new Configurator.GraphMimeTypeDetectorDetails<Object>(detectorPath, this.builder);
            return new Configurator.ClassChooser<MimeTypeDetector, Configurator.MimeTypeDetectorDetails<ReturnType>>(detectorPath, details);
        }

        @Override
        protected Name nameFor(String name) {
            Name result = NAMES_TO_MAP.get(name);
            if (result == null) {
                result = (Name)this.context.getValueFactories().getNameFactory().create(name);
            }
            return result;
        }
    }
}

