/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathExpression;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.repository.Configurator;
import org.jboss.dna.repository.DnaLexicon;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.RepositoryLibrary;
import org.jboss.dna.repository.RepositoryService;
import org.jboss.dna.repository.mimetype.MimeTypeDetectorConfig;
import org.jboss.dna.repository.observation.ObservationService;
import org.jboss.dna.repository.sequencer.SequencerConfig;
import org.jboss.dna.repository.sequencer.SequencingService;
import org.jboss.dna.repository.service.AdministeredService;
import org.jboss.dna.repository.util.JcrExecutionContext;
import org.jboss.dna.repository.util.SessionFactory;
import org.jboss.dna.repository.util.SimpleSessionFactory;

@Immutable
public class DnaEngine {
    public static final String CONFIGURATION_REPOSITORY_NAME = "dna:configuration";
    private final Configurator.ConfigurationRepository configuration;
    private final ConfigurationScanner scanner;
    private final Problems problems = new SimpleProblems();
    private final ExecutionContext context;
    private final List<AdministeredService> services;
    private final SessionFactory jcrSessionFactory;
    private final RepositoryService repositoryService;
    private final ObservationService observationService;
    private final SequencingService sequencingService;
    private final ExecutorService executorService;
    private final RepositoryConnectionFactory connectionFactory;

    DnaEngine(ExecutionContext context, Configurator.ConfigurationRepository configuration) {
        this.context = context;
        this.configuration = configuration;
        this.scanner = new ConfigurationScanner(this.problems, this.context, this.configuration);
        RepositorySource configSource = this.configuration.getRepositorySource();
        RepositoryLibrary library = new RepositoryLibrary();
        library.addSource(configSource);
        Path pathToConfigurationRoot = this.configuration.getPath();
        this.repositoryService = new RepositoryService(library, configSource.getName(), "", pathToConfigurationRoot, context);
        for (MimeTypeDetectorConfig config : this.scanner.getMimeTypeDetectors()) {
            library.getMimeTypeDetectors().addDetector(config);
        }
        this.executorService = new ScheduledThreadPoolExecutor(10);
        this.sequencingService = new SequencingService();
        this.jcrSessionFactory = this.createSessionFactory();
        JcrExecutionContext jcrContext = new JcrExecutionContext(context, this.jcrSessionFactory, "");
        this.sequencingService.setExecutionContext(jcrContext);
        this.sequencingService.setExecutorService(this.executorService);
        for (SequencerConfig sequencerConfig : this.scanner.getSequencingConfigurations()) {
            this.sequencingService.addSequencer(sequencerConfig);
        }
        this.observationService = null;
        this.services = Arrays.asList(this.repositoryService, this.sequencingService);
        this.connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                RepositorySource source = DnaEngine.this.getRepositorySource(sourceName);
                if (sourceName == null) {
                    throw new RepositorySourceException(sourceName);
                }
                return source.getConnection();
            }
        };
    }

    protected SessionFactory createSessionFactory() {
        return new SimpleSessionFactory();
    }

    public Problems getProblems() {
        return this.problems;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    public final RepositorySource getRepositorySource(String repositoryName) {
        return this.repositoryService.getRepositorySourceManager().getSource(repositoryName);
    }

    public final RepositoryConnectionFactory getRepositoryConnectionFactory() {
        return this.connectionFactory;
    }

    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final ObservationService getObservationService() {
        return this.observationService;
    }

    public final SequencingService getSequencingService() {
        return this.sequencingService;
    }

    public void start() {
        for (AdministeredService service : this.services) {
            service.getAdministrator().start();
        }
    }

    public void shutdown() {
        for (AdministeredService service : this.services) {
            service.getAdministrator().shutdown();
        }
        try {
            this.executorService.awaitTermination(600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        this.executorService.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigurationScanner {
        private final Problems problems;
        private final ExecutionContext context;
        private final Configurator.ConfigurationRepository configurationRepository;

        protected ConfigurationScanner(Problems problems, ExecutionContext context, Configurator.ConfigurationRepository configurationRepository) {
            this.problems = problems;
            this.context = context;
            this.configurationRepository = configurationRepository;
        }

        public List<MimeTypeDetectorConfig> getMimeTypeDetectors() {
            ArrayList<MimeTypeDetectorConfig> detectors = new ArrayList<MimeTypeDetectorConfig>();
            Graph graph = Graph.create((RepositorySource)this.configurationRepository.getRepositorySource(), (ExecutionContext)this.context);
            Path pathToSequencersNode = this.context.getValueFactories().getPathFactory().create(this.configurationRepository.getPath(), new Name[]{DnaLexicon.MIME_TYPE_DETECTORS});
            try {
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(2).at(pathToSequencersNode);
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(DnaLexicon.READABLE_NAME);
                skipProperties.add(DnaLexicon.DESCRIPTION);
                skipProperties.add(DnaLexicon.CLASSNAME);
                skipProperties.add(DnaLexicon.CLASSPATH);
                skipProperties.add(DnaLexicon.PATH_EXPRESSIONS);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                for (Location detectorLocation : subgraph.getRoot().getChildren()) {
                    Node node = subgraph.getNode(detectorLocation);
                    String name = this.stringValueOf(node, DnaLexicon.READABLE_NAME);
                    String desc = this.stringValueOf(node, DnaLexicon.DESCRIPTION);
                    String classname = this.stringValueOf(node, DnaLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf(node, DnaLexicon.CLASSPATH);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : node.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    MimeTypeDetectorConfig config = new MimeTypeDetectorConfig(name, desc, properties, classname, classpath);
                    detectors.add(config);
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            return detectors;
        }

        public List<SequencerConfig> getSequencingConfigurations() {
            ArrayList<SequencerConfig> configs = new ArrayList<SequencerConfig>();
            Graph graph = Graph.create((RepositorySource)this.configurationRepository.getRepositorySource(), (ExecutionContext)this.context);
            Path pathToSequencersNode = this.context.getValueFactories().getPathFactory().create(this.configurationRepository.getPath(), new Name[]{DnaLexicon.SEQUENCERS});
            try {
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(2).at(pathToSequencersNode);
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(DnaLexicon.READABLE_NAME);
                skipProperties.add(DnaLexicon.DESCRIPTION);
                skipProperties.add(DnaLexicon.CLASSNAME);
                skipProperties.add(DnaLexicon.CLASSPATH);
                skipProperties.add(DnaLexicon.PATH_EXPRESSIONS);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                for (Location sequencerLocation : subgraph.getRoot().getChildren()) {
                    Node sequencerNode = subgraph.getNode(sequencerLocation);
                    String name = this.stringValueOf(sequencerNode, DnaLexicon.READABLE_NAME);
                    String desc = this.stringValueOf(sequencerNode, DnaLexicon.DESCRIPTION);
                    String classname = this.stringValueOf(sequencerNode, DnaLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf(sequencerNode, DnaLexicon.CLASSPATH);
                    String[] expressionStrings = this.stringValuesOf(sequencerNode, DnaLexicon.PATH_EXPRESSIONS);
                    ArrayList<PathExpression> pathExpressions = new ArrayList<PathExpression>();
                    if (expressionStrings != null) {
                        for (String expressionString : expressionStrings) {
                            try {
                                pathExpressions.add(PathExpression.compile((String)expressionString));
                            }
                            catch (Throwable t) {
                                this.problems.addError(t, RepositoryI18n.pathExpressionIsInvalidOnSequencer, expressionString, name, new Object[]{t.getLocalizedMessage()});
                            }
                        }
                    }
                    String[] goodExpressionStrings = new String[pathExpressions.size()];
                    for (int i = 0; i != pathExpressions.size(); ++i) {
                        PathExpression expression = (PathExpression)pathExpressions.get(i);
                        goodExpressionStrings[i] = expression.getExpression();
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : sequencerNode.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    SequencerConfig config = new SequencerConfig(name, desc, properties, classname, classpath, goodExpressionStrings);
                    configs.add(config);
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            return configs;
        }

        private String stringValueOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null) {
                return null;
            }
            if (property.isEmpty()) {
                return null;
            }
            return (String)this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
        }

        private String[] stringValuesOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null) {
                return null;
            }
            return (String[])this.context.getValueFactories().getStringFactory().create(property.getValuesAsArray());
        }
    }
}

