/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositoryConnectionPool;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.mimetype.MimeTypeDetectors;
import org.jboss.dna.repository.service.AbstractServiceAdministrator;
import org.jboss.dna.repository.service.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryLibrary
implements RepositoryConnectionFactory {
    private final MimeTypeDetectors mimeTypeDetectors = new MimeTypeDetectors();
    private final ServiceAdministrator administrator = new Administrator();
    private final ReadWriteLock sourcesLock = new ReentrantReadWriteLock();
    private final CopyOnWriteArrayList<RepositoryConnectionPool> pools = new CopyOnWriteArrayList();
    private RepositoryConnectionFactory delegate;
    protected final ExecutionContext executionContext;
    private final RepositoryContext repositoryContext;

    public RepositoryLibrary() {
        this(new ExecutionContext(), null);
    }

    public RepositoryLibrary(RepositoryConnectionFactory delegate) {
        this(new ExecutionContext(), delegate);
    }

    public RepositoryLibrary(ExecutionContext executionContext) {
        this(executionContext, null);
    }

    public RepositoryLibrary(ExecutionContext executionContext, RepositoryConnectionFactory delegate) {
        CheckArg.isNotNull((Object)executionContext, (String)"executionContext");
        this.delegate = delegate;
        this.executionContext = executionContext;
        this.repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return RepositoryLibrary.this.executionContext;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return RepositoryLibrary.this;
            }
        };
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public MimeTypeDetectors getMimeTypeDetectors() {
        return this.mimeTypeDetectors;
    }

    public RepositoryConnectionFactory getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RepositoryConnectionFactory delegate) {
        this.delegate = delegate;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    protected void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                pool.shutdown();
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.awaitTermination(timeout, unit)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminating() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (!pool.isTerminating()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.isTerminated()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    public Collection<String> getSourceNames() {
        HashSet<String> sourceNames = new HashSet<String>();
        for (RepositoryConnectionPool pool : this.pools) {
            sourceNames.add(pool.getRepositorySource().getName());
        }
        return Collections.unmodifiableCollection(sourceNames);
    }

    public Collection<RepositorySource> getSources() {
        LinkedList<RepositorySource> sources = new LinkedList<RepositorySource>();
        for (RepositoryConnectionPool pool : this.pools) {
            sources.add(pool.getRepositorySource());
        }
        return Collections.unmodifiableCollection(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource getSource(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositorySource repositorySource = source;
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnectionPool getConnectionPool(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositoryConnectionPool repositoryConnectionPool = existingPool;
                return repositoryConnectionPool;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(RepositorySource source) {
        if (source == null) {
            return false;
        }
        try {
            this.sourcesLock.writeLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                if (!existingPool.getRepositorySource().getName().equals(source.getName())) continue;
                boolean bl = false;
                return bl;
            }
            source.initialize(this.repositoryContext);
            RepositoryConnectionPool pool = new RepositoryConnectionPool(source);
            this.pools.add(pool);
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
    }

    public boolean removeSource(RepositorySource source, long timeToAwait, TimeUnit unit) throws InterruptedException {
        return this.removeSource(source.getName(), timeToAwait, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource removeSource(String name, long timeToAwait, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.writeLock().lock();
            Iterator<RepositoryConnectionPool> i$ = this.pools.iterator();
            if (i$.hasNext()) {
                RepositoryConnectionPool existingPool = i$.next();
                if (existingPool.getRepositorySource().getName().equals(name)) {
                    existingPool.shutdown();
                    if (timeToAwait > 0L) {
                        existingPool.awaitTermination(timeToAwait, unit);
                    }
                }
                RepositorySource repositorySource = existingPool.getRepositorySource();
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection createConnection(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositoryConnection repositoryConnection = existingPool.getConnection();
                return repositoryConnection;
            }
            RepositoryConnectionFactory delegate = this.delegate;
            if (delegate != null) {
                RepositoryConnection repositoryConnection = delegate.createConnection(sourceName);
                return repositoryConnection;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryLibrary.this.start();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RepositoryLibrary.this.shutdown();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return RepositoryLibrary.this.awaitTermination(timeout, unit);
        }

        protected boolean doCheckIsTerminated() {
            return RepositoryLibrary.this.isTerminated();
        }
    }
}

