/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.Reflection;
import org.jboss.dna.connector.federation.FederationException;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyType;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.repository.DnaLexicon;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.RepositoryLibrary;
import org.jboss.dna.repository.service.AbstractServiceAdministrator;
import org.jboss.dna.repository.service.AdministeredService;
import org.jboss.dna.repository.service.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryService
implements AdministeredService {
    private final ExecutionContext context;
    private final RepositoryLibrary sources;
    private final String configurationSourceName;
    private final String configurationWorkspaceName;
    private final Path pathToConfigurationRoot;
    private final Administrator administrator = new Administrator();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public RepositoryService(RepositoryLibrary sources, String configurationSourceName, String configurationWorkspaceName, ExecutionContext context) {
        this(sources, configurationSourceName, configurationWorkspaceName, null, context);
    }

    public RepositoryService(RepositoryLibrary sources, String configurationSourceName, String configurationWorkspaceName, Path pathToConfigurationRoot, ExecutionContext context) {
        CheckArg.isNotNull((Object)configurationSourceName, (String)"configurationSourceName");
        CheckArg.isNotNull((Object)sources, (String)"sources");
        CheckArg.isNotNull((Object)context, (String)"context");
        if (pathToConfigurationRoot == null) {
            pathToConfigurationRoot = (Path)context.getValueFactories().getPathFactory().create("/dna:system");
        }
        this.sources = sources;
        this.pathToConfigurationRoot = pathToConfigurationRoot;
        this.configurationSourceName = configurationSourceName;
        this.configurationWorkspaceName = configurationWorkspaceName;
        this.context = context;
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public String getConfigurationSourceName() {
        return this.configurationSourceName;
    }

    public String getConfigurationWorkspaceName() {
        return this.configurationWorkspaceName;
    }

    public RepositoryLibrary getRepositorySourceManager() {
        return this.sources;
    }

    public ExecutionContext getExecutionEnvironment() {
        return this.context;
    }

    public String getJndiName() {
        return null;
    }

    protected synchronized void startService() {
        if (!this.started.get()) {
            SimpleProblems problems = new SimpleProblems();
            Graph graph = Graph.create((String)this.getConfigurationSourceName(), (RepositoryConnectionFactory)this.sources, (ExecutionContext)this.context);
            Path pathToSourcesNode = this.context.getValueFactories().getPathFactory().create(this.pathToConfigurationRoot, new Name[]{DnaLexicon.SOURCES});
            try {
                String workspaceName = this.getConfigurationWorkspaceName();
                if (workspaceName != null) {
                    graph.useWorkspace(workspaceName);
                }
                Subgraph sourcesGraph = (Subgraph)graph.getSubgraphOfDepth(3).at(pathToSourcesNode);
                for (Location location : sourcesGraph.getRoot().getChildren()) {
                    Node sourceNode = sourcesGraph.getNode(location);
                    this.sources.addSource(this.createRepositorySource(location.getPath(), sourceNode.getPropertiesByName(), (Problems)problems));
                }
            }
            catch (PathNotFoundException e) {
            }
            catch (Throwable err) {
                throw new FederationException(RepositoryI18n.errorStartingRepositoryService.text(new Object[0]), err);
            }
            this.started.set(true);
        }
    }

    protected RepositorySource createRepositorySource(Path path, Map<Name, Property> properties, Problems problems) {
        ValueFactories valueFactories = this.context.getValueFactories();
        ValueFactory stringFactory = valueFactories.getStringFactory();
        Property classnameProperty = properties.get(DnaLexicon.CLASSNAME);
        Property classpathProperty = properties.get(DnaLexicon.CLASSPATH);
        if (classnameProperty == null) {
            problems.addError(RepositoryI18n.requiredPropertyIsMissingFromNode, new Object[]{DnaLexicon.CLASSNAME, path});
        }
        if (problems.hasErrors()) {
            return null;
        }
        String classname = (String)stringFactory.create(classnameProperty.getValues().next());
        String[] classpath = classpathProperty == null ? new String[]{} : (String[])stringFactory.create(classpathProperty.getValuesAsArray());
        ClassLoader classLoader = this.context.getClassLoader(classpath);
        RepositorySource source = null;
        try {
            Class<?> sourceClass = classLoader.loadClass(classname);
            source = (RepositorySource)sourceClass.newInstance();
        }
        catch (ClassNotFoundException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToLoadClassUsingClasspath, new Object[]{classname, classpath});
        }
        catch (IllegalAccessException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToAccessClassUsingClasspath, new Object[]{classname, classpath});
        }
        catch (Throwable err) {
            problems.addError(err, RepositoryI18n.unableToInstantiateClassUsingClasspath, new Object[]{classname, classpath});
        }
        Property nameProperty = this.context.getPropertyFactory().create(JcrLexicon.NAME, new Object[]{path.getLastSegment().getName().getLocalName()});
        properties.put(JcrLexicon.NAME, nameProperty);
        Reflection reflection = new Reflection(source.getClass());
        for (Map.Entry<Name, Property> entry : properties.entrySet()) {
            String msg;
            Name propertyName = entry.getKey();
            Property property = entry.getValue();
            String javaPropertyName = propertyName.getLocalName();
            if (property.isEmpty()) continue;
            Object[] value = null;
            Method setter = null;
            try {
                Class<?> paramType;
                PropertyType allowedType;
                Class<?>[] parameterTypes;
                setter = reflection.findFirstMethod("set" + javaPropertyName, false);
                if (setter == null || (parameterTypes = setter.getParameterTypes()).length != 1 || (allowedType = PropertyType.discoverType(paramType = parameterTypes[0])) == null) continue;
                ValueFactory factory = this.context.getValueFactories().getValueFactory(allowedType);
                if (paramType.isArray()) {
                    int i;
                    Object[] primitiveValues;
                    if (paramType.getComponentType().isArray()) continue;
                    Object[] values = factory.create(property.getValuesAsArray());
                    Class<?> componentType = paramType.getComponentType();
                    if (Integer.TYPE.equals(componentType)) {
                        primitiveValues = new int[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = ((Long)values[i]).intValue();
                        }
                        value = primitiveValues;
                    } else if (Short.TYPE.equals(componentType)) {
                        primitiveValues = new short[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = ((Long)values[i]).shortValue();
                        }
                        value = primitiveValues;
                    } else if (Long.TYPE.equals(componentType)) {
                        primitiveValues = new long[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = (int)((Long)values[i]).longValue();
                        }
                        value = primitiveValues;
                    } else if (Double.TYPE.equals(componentType)) {
                        primitiveValues = new double[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = (int)((Double)values[i]).doubleValue();
                        }
                        value = primitiveValues;
                    } else if (Float.TYPE.equals(componentType)) {
                        primitiveValues = new float[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = (int)((Double)values[i]).floatValue();
                        }
                        value = primitiveValues;
                    } else if (Boolean.TYPE.equals(componentType)) {
                        primitiveValues = new boolean[values.length];
                        for (i = 0; i != values.length; ++i) {
                            primitiveValues[i] = ((Boolean)values[i]).booleanValue() ? 1 : 0;
                        }
                        value = primitiveValues;
                    } else {
                        value = values;
                    }
                } else {
                    value = factory.create(property.getFirstValue());
                    if (Integer.TYPE.equals(paramType)) {
                        value = new Integer(((Long)value).intValue());
                    } else if (Short.TYPE.equals(paramType)) {
                        value = new Short(((Long)value).shortValue());
                    } else if (Float.TYPE.equals(paramType)) {
                        value = new Float(((Double)value).floatValue());
                    }
                }
                String msg2 = "Setting property {0} to {1} on source at {2} in configuration repository {3} in workspace {4}";
                Logger.getLogger(this.getClass()).trace(msg2, new Object[]{javaPropertyName, value, path, this.configurationSourceName, this.configurationWorkspaceName});
                setter.invoke((Object)source, new Object[]{value});
            }
            catch (SecurityException err) {
                Logger.getLogger(this.getClass()).debug((Throwable)err, "Error invoking {0}.{1}", new Object[]{source.getClass(), setter});
            }
            catch (IllegalArgumentException err) {
                msg = "Invalid argument invoking {0} with parameter {1} on source at {2} in configuration repository {3} in workspace {4}";
                Logger.getLogger(this.getClass()).debug((Throwable)err, msg, new Object[]{setter, value, path, this.configurationSourceName, this.configurationWorkspaceName});
            }
            catch (IllegalAccessException err) {
                Logger.getLogger(this.getClass()).debug((Throwable)err, "Error invoking {0}.{1}", new Object[]{source.getClass(), setter});
            }
            catch (InvocationTargetException err) {
                msg = "Error invoking {0} with parameter {1} on source at {2} in configuration repository {3} in workspace {4}";
                Logger.getLogger(this.getClass()).debug(err.getTargetException(), msg, new Object[]{setter, value, path, this.configurationSourceName, this.configurationWorkspaceName});
            }
        }
        return source;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.PAUSED);
        }

        protected boolean doCheckIsTerminated() {
            return true;
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryService.this.startService();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }
}

