/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.mimetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.ComponentConfig;
import org.jboss.dna.common.component.ComponentLibrary;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.repository.mimetype.MimeTypeDetectorConfig;

@ThreadSafe
public final class MimeTypeDetectors
implements MimeTypeDetector {
    public static final MimeTypeDetectors DEFAULT_DETECTORS = new MimeTypeDetectors();
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(MimeTypeDetectors.class.getClassLoader());
    private final ComponentLibrary<MimeTypeDetector, MimeTypeDetectorConfig> library;
    private final AtomicReference<Logger> logger = new AtomicReference<Logger>(Logger.getLogger(this.getClass()));

    public MimeTypeDetectors() {
        this.library = new ComponentLibrary(true);
        this.library.setClassLoaderFactory(DEFAULT_CLASSLOADER_FACTORY);
    }

    public boolean addDetector(MimeTypeDetectorConfig config) {
        return this.library.add((ComponentConfig)config);
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.library.getClassLoaderFactory();
    }

    public Logger getLogger() {
        return this.logger.get();
    }

    public String mimeTypeOf(String name, InputStream content) throws IOException {
        if (content != null && content.markSupported()) {
            content.mark(Integer.MAX_VALUE);
        }
        for (MimeTypeDetector detector : this.library.getInstances()) {
            String mimeType = detector.mimeTypeOf(name, content);
            if (mimeType == null) continue;
            return mimeType;
        }
        if (content != null && content.markSupported()) {
            try {
                content.reset();
                int chr = content.read();
                while (chr >= 0) {
                    if (chr == 0) {
                        return "application/octet-stream";
                    }
                    chr = content.read();
                }
            }
            catch (IOException meansTooManyBytesRead) {
                return "application/octet-stream";
            }
        }
        return "text/plain";
    }

    public boolean removeDetector(MimeTypeDetectorConfig config) {
        return this.library.remove((ComponentConfig)config);
    }

    public void setClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.library.setClassLoaderFactory(classLoaderFactory != null ? classLoaderFactory : DEFAULT_CLASSLOADER_FACTORY);
    }

    public void setLogger(Logger logger) {
        this.logger.set(logger != null ? logger : Logger.getLogger(this.getClass()));
    }
}

