/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.observation.NodeChangeListener;
import org.jboss.dna.repository.observation.NodeChanges;
import org.jboss.dna.repository.rules.RuleService;
import org.jboss.dna.repository.rules.RuleSet;
import org.jboss.dna.repository.util.JcrExecutionContext;
import org.jboss.dna.repository.util.JcrTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RuleSetRepositoryMonitor
implements NodeChangeListener {
    public static final String DEFAULT_JCR_ABSOLUTE_PATH = "/dna:system/dna:ruleSets/";
    protected static final String JCR_PATH_DELIM = "/";
    private final JcrExecutionContext executionContext;
    private final RuleService ruleService;
    private final String jcrAbsolutePath;
    private final Pattern ruleSetNamePattern;
    private final ExecutorService executorService;
    private Logger logger;

    public RuleSetRepositoryMonitor(RuleService ruleService, String jcrAbsolutePath, JcrExecutionContext executionContext) {
        CheckArg.isNotNull((Object)ruleService, (String)"rule service");
        CheckArg.isNotNull((Object)((Object)executionContext), (String)"execution context");
        this.ruleService = ruleService;
        this.executionContext = executionContext;
        this.executorService = Executors.newSingleThreadExecutor();
        this.logger = Logger.getLogger(this.getClass());
        if (jcrAbsolutePath != null) {
            jcrAbsolutePath = jcrAbsolutePath.trim();
        }
        this.jcrAbsolutePath = jcrAbsolutePath != null && jcrAbsolutePath.length() != 0 ? jcrAbsolutePath : DEFAULT_JCR_ABSOLUTE_PATH;
        try {
            String leadingPath = this.jcrAbsolutePath;
            if (!leadingPath.endsWith(JCR_PATH_DELIM)) {
                leadingPath = leadingPath + JCR_PATH_DELIM;
            }
            this.ruleSetNamePattern = Pattern.compile(leadingPath + "([^/]+)/?.*");
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(RepositoryI18n.unableToBuildRuleSetRegularExpressionPattern.text(new Object[]{e.getPattern(), jcrAbsolutePath, e.getDescription()}));
        }
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    public String getAbsolutePathToRuleSets() {
        return this.jcrAbsolutePath;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onNodeChanges(NodeChanges changes) {
        final HashMap<String, HashSet<String>> ruleSetNamesByWorkspaceName = new HashMap<String, HashSet<String>>();
        for (NodeChange nodeChange : changes) {
            Matcher matcher;
            if (nodeChange.isNotOnPath(this.jcrAbsolutePath) || !(matcher = this.ruleSetNamePattern.matcher(nodeChange.getAbsolutePath())).matches()) continue;
            String ruleSetName = matcher.group(1);
            String workspaceName = nodeChange.getRepositoryWorkspaceName();
            HashSet<String> ruleSetNames = (HashSet<String>)ruleSetNamesByWorkspaceName.get(workspaceName);
            if (ruleSetNames == null) {
                ruleSetNames = new HashSet<String>();
                ruleSetNamesByWorkspaceName.put(workspaceName, ruleSetNames);
            }
            ruleSetNames.add(ruleSetName);
        }
        if (ruleSetNamesByWorkspaceName.isEmpty()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            public void run() {
                RuleSetRepositoryMonitor.this.processRuleSets(ruleSetNamesByWorkspaceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRuleSets(Map<String, Set<String>> ruleSetNamesByWorkspaceName) {
        JcrTools tools = this.executionContext.getTools();
        String relPathToRuleSets = this.getAbsolutePathToRuleSets().substring(1);
        for (Map.Entry<String, Set<String>> entry : ruleSetNamesByWorkspaceName.entrySet()) {
            String workspaceName = entry.getKey();
            Session session = null;
            try {
                session = this.executionContext.getSessionFactory().createSession(workspaceName);
                Node ruleSetsNode = session.getRootNode().getNode(relPathToRuleSets);
                for (String ruleSetName : entry.getValue()) {
                    if (ruleSetsNode.hasNode(ruleSetName)) {
                        Node ruleSetNode = ruleSetsNode.getNode(ruleSetName);
                        RuleSet ruleSet = this.buildRuleSet(ruleSetName, ruleSetNode, tools);
                        if (ruleSet == null) continue;
                        this.getRuleService().addRuleSet(ruleSet);
                        continue;
                    }
                    this.getRuleService().removeRuleSet(ruleSetName);
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error((Throwable)e, RepositoryI18n.errorObtainingSessionToRepositoryWorkspace, new Object[]{workspaceName});
            }
            finally {
                if (session == null) continue;
                session.logout();
            }
        }
    }

    protected RuleSet buildRuleSet(String name, Node ruleSetNode, JcrTools tools) {
        if (ruleSetNode == null) {
            return null;
        }
        SimpleProblems simpleProblems = new SimpleProblems();
        String description = tools.getPropertyAsString(ruleSetNode, "jcr:description", false, (Problems)simpleProblems);
        String classname = tools.getPropertyAsString(ruleSetNode, "dna:classname", true, (Problems)simpleProblems);
        String[] classpath = tools.getPropertyAsStringArray(ruleSetNode, "dna:classpath", false, (Problems)simpleProblems, new String[0]);
        String providerUri = tools.getPropertyAsString(ruleSetNode, "dna:serviceProviderUri", true, (Problems)simpleProblems);
        String ruleSetUri = tools.getPropertyAsString(ruleSetNode, "dna:ruleSetUri", true, name, (Problems)simpleProblems);
        String rules = tools.getPropertyAsString(ruleSetNode, "dna:rules", true, (Problems)simpleProblems);
        Map<String, Object> properties = tools.loadProperties(ruleSetNode, (Problems)simpleProblems);
        if (simpleProblems.hasProblems()) {
            try {
                if (tools.storeProblems(ruleSetNode, (Problems)simpleProblems)) {
                    ruleSetNode.save();
                }
            }
            catch (RepositoryException e) {
                this.logger.error((Throwable)e, RepositoryI18n.errorWritingProblemsOnRuleSet, new Object[]{tools.getReadable(ruleSetNode)});
            }
            return null;
        }
        try {
            if (tools.removeProblems(ruleSetNode)) {
                ruleSetNode.save();
            }
        }
        catch (RepositoryException e) {
            this.logger.error((Throwable)e, RepositoryI18n.errorWritingProblemsOnRuleSet, new Object[]{tools.getReadable(ruleSetNode)});
        }
        return new RuleSet(name, description, classname, classpath, providerUri, ruleSetUri, rules, properties);
    }
}

