/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.ComponentLibrary;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.observation.NodeChangeListener;
import org.jboss.dna.repository.observation.NodeChanges;
import org.jboss.dna.repository.sequencer.Sequencer;
import org.jboss.dna.repository.sequencer.SequencerConfig;
import org.jboss.dna.repository.sequencer.SequencerException;
import org.jboss.dna.repository.sequencer.SequencerLibrary;
import org.jboss.dna.repository.sequencer.SequencerPathExpression;
import org.jboss.dna.repository.service.AbstractServiceAdministrator;
import org.jboss.dna.repository.service.AdministeredService;
import org.jboss.dna.repository.service.ServiceAdministrator;
import org.jboss.dna.repository.util.JcrExecutionContext;
import org.jboss.dna.repository.util.RepositoryNodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencingService
implements AdministeredService,
NodeChangeListener {
    public static final Selector DEFAULT_SEQUENCER_SELECTOR = new DefaultSelector();
    public static final NodeFilter DEFAULT_NODE_FILTER = new DefaultNodeFilter();
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(SequencingService.class.getClassLoader());
    private JcrExecutionContext executionContext;
    private SequencerLibrary sequencerLibrary = new SequencerLibrary();
    private Selector sequencerSelector = DEFAULT_SEQUENCER_SELECTOR;
    private NodeFilter nodeFilter = DEFAULT_NODE_FILTER;
    private ExecutorService executorService;
    private final Statistics statistics = new Statistics();
    private final Administrator administrator = new Administrator();

    public SequencingService() {
        this.sequencerLibrary.setClassLoaderFactory(DEFAULT_CLASSLOADER_FACTORY);
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    protected ComponentLibrary<Sequencer, SequencerConfig> getSequencerLibrary() {
        return this.sequencerLibrary;
    }

    public boolean addSequencer(SequencerConfig config) {
        return this.sequencerLibrary.add(config);
    }

    public boolean updateSequencer(SequencerConfig config) {
        return this.sequencerLibrary.update(config);
    }

    public boolean removeSequencer(SequencerConfig config) {
        return this.sequencerLibrary.remove(config);
    }

    public JcrExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(JcrExecutionContext executionContext) {
        CheckArg.isNotNull((Object)((Object)executionContext), (String)"execution context");
        if (this.getAdministrator().isStarted()) {
            throw new IllegalStateException(RepositoryI18n.unableToChangeExecutionContextWhileRunning.text(new Object[0]));
        }
        this.executionContext = executionContext;
        this.sequencerLibrary.setClassLoaderFactory((ClassLoaderFactory)executionContext);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        CheckArg.isNotNull((Object)executorService, (String)"executor service");
        if (this.getAdministrator().isStarted()) {
            throw new IllegalStateException(RepositoryI18n.unableToChangeExecutionContextWhileRunning.text(new Object[0]));
        }
        this.executorService = executorService;
    }

    protected ExecutorService createDefaultExecutorService() {
        return Executors.newSingleThreadExecutor();
    }

    protected void startService() {
        if (this.getExecutionContext() == null) {
            throw new IllegalStateException(RepositoryI18n.unableToStartSequencingServiceWithoutExecutionContext.text(new Object[0]));
        }
        if (this.executorService == null) {
            this.executorService = this.createDefaultExecutorService();
        }
        assert (this.executorService != null);
        assert (this.sequencerSelector != null);
        assert (this.nodeFilter != null);
        assert (this.sequencerLibrary != null);
    }

    protected void shutdownService() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected boolean isServiceTerminated() {
        if (this.executorService != null) {
            return this.executorService.isTerminated();
        }
        return true;
    }

    protected boolean doAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executorService == null || this.executorService.isTerminated()) {
            return true;
        }
        return this.executorService.awaitTermination(timeout, unit);
    }

    public Selector getSequencerSelector() {
        return this.sequencerSelector;
    }

    public void setSequencerSelector(Selector sequencerSelector) {
        this.sequencerSelector = sequencerSelector != null ? sequencerSelector : DEFAULT_SEQUENCER_SELECTOR;
    }

    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter != null ? nodeFilter : DEFAULT_NODE_FILTER;
    }

    @Override
    public void onNodeChanges(NodeChanges changes) {
        NodeFilter filter = this.getNodeFilter();
        for (final NodeChange changedNode : changes) {
            if (!filter.accept(changedNode)) continue;
            try {
                this.executorService.execute(new Runnable(){

                    public void run() {
                        SequencingService.this.processChangedNode(changedNode);
                    }
                });
            }
            catch (RejectedExecutionException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChangedNode(NodeChange changedNode) {
        JcrExecutionContext context = this.getExecutionContext();
        Logger logger = context.getLogger(this.getClass());
        assert (logger != null);
        try {
            String repositoryWorkspaceName = changedNode.getRepositoryWorkspaceName();
            Session session = null;
            try {
                String nodePath = changedNode.getAbsolutePath();
                HashMap<SequencerCall, HashSet<RepositoryNodePath>> sequencerCalls = new HashMap<SequencerCall, HashSet<RepositoryNodePath>>();
                List allSequencers = this.sequencerLibrary.getInstances();
                List<Sequencer> sequencers = new ArrayList<Sequencer>(allSequencers.size());
                for (Sequencer sequencer : allSequencers) {
                    SequencerConfig config = (SequencerConfig)sequencer.getConfiguration();
                    block23: for (SequencerPathExpression pathExpression : config.getPathExpressions()) {
                        for (String propertyName : changedNode.getModifiedProperties()) {
                            String path = nodePath + "/@" + propertyName;
                            SequencerPathExpression.Matcher matcher = pathExpression.matcher(path);
                            if (!matcher.matches()) continue;
                            RepositoryNodePath outputPath = RepositoryNodePath.parse(matcher.getOutputPath(), repositoryWorkspaceName);
                            SequencerCall call = new SequencerCall(sequencer, propertyName);
                            HashSet<RepositoryNodePath> outputPaths = (HashSet<RepositoryNodePath>)sequencerCalls.get(call);
                            if (outputPaths == null) {
                                outputPaths = new HashSet<RepositoryNodePath>();
                                sequencerCalls.put(call, outputPaths);
                            }
                            outputPaths.add(outputPath);
                            sequencers.add(sequencer);
                            continue block23;
                        }
                    }
                }
                Node node = null;
                if (!sequencers.isEmpty()) {
                    session = context.getSessionFactory().createSession(repositoryWorkspaceName);
                    String relPath = changedNode.getAbsolutePath().replaceAll("^/+", "");
                    node = session.getRootNode().getNode(relPath);
                    sequencers = this.sequencerSelector.selectSequencers(sequencers, node, changedNode);
                }
                if (sequencers.isEmpty()) {
                    this.statistics.recordNodeSkipped();
                    if (logger.isDebugEnabled()) {
                        logger.trace("Skipping '{0}': no sequencers matched this condition", new Object[]{changedNode});
                    }
                } else {
                    for (Map.Entry entry : sequencerCalls.entrySet()) {
                        SequencerCall sequencerCall = (SequencerCall)entry.getKey();
                        Set outputPaths = (Set)entry.getValue();
                        Sequencer sequencer = sequencerCall.getSequencer();
                        String sequencerName = ((SequencerConfig)sequencer.getConfiguration()).getName();
                        String propertyName = sequencerCall.getSequencedPropertyName();
                        assert (outputPaths != null && outputPaths.size() != 0);
                        SimpleProblems problems = new SimpleProblems();
                        JcrExecutionContext sequencerContext = context.clone();
                        try {
                            sequencer.execute(node, propertyName, changedNode, outputPaths, sequencerContext, (Problems)problems);
                        }
                        catch (RepositoryException e) {
                            logger.error((Throwable)e, RepositoryI18n.errorInRepositoryWhileSequencingNode, new Object[]{sequencerName, changedNode});
                        }
                        catch (SequencerException e) {
                            logger.error((Throwable)e, RepositoryI18n.errorWhileSequencingNode, new Object[]{sequencerName, changedNode});
                        }
                        finally {
                            try {
                                if (session == null) continue;
                                session.save();
                            }
                            finally {
                                sequencerContext.close();
                            }
                        }
                    }
                    this.statistics.recordNodeSequenced();
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        catch (RepositoryException e) {
            logger.error((Throwable)e, RepositoryI18n.errorInRepositoryWhileFindingSequencersToRunAgainstNode, new Object[]{changedNode});
        }
        catch (Throwable e) {
            logger.error(e, RepositoryI18n.errorFindingSequencersToRunAgainstNode, new Object[]{changedNode});
        }
    }

    @Immutable
    protected class SequencerCall {
        private final Sequencer sequencer;
        private final String sequencerName;
        private final String sequencedPropertyName;
        private final int hc;

        protected SequencerCall(Sequencer sequencer, String sequencedPropertyName) {
            this.sequencer = sequencer;
            this.sequencerName = ((SequencerConfig)sequencer.getConfiguration()).getName();
            this.sequencedPropertyName = sequencedPropertyName;
            this.hc = HashCode.compute((Object[])new Object[]{this.sequencerName, this.sequencedPropertyName});
        }

        public Sequencer getSequencer() {
            return this.sequencer;
        }

        public String getSequencedPropertyName() {
            return this.sequencedPropertyName;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SequencerCall) {
                SequencerCall that = (SequencerCall)obj;
                if (!this.sequencerName.equals(that.sequencerName)) {
                    return false;
                }
                return this.sequencedPropertyName.equals(that.sequencedPropertyName);
            }
            return false;
        }
    }

    @ThreadSafe
    public class Statistics {
        private final AtomicLong numberOfNodesSequenced = new AtomicLong(0L);
        private final AtomicLong numberOfNodesSkipped = new AtomicLong(0L);
        private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

        protected Statistics() {
        }

        public Statistics reset() {
            this.startTime.set(System.currentTimeMillis());
            this.numberOfNodesSequenced.set(0L);
            this.numberOfNodesSkipped.set(0L);
            return this;
        }

        public long getStartTime() {
            return this.startTime.get();
        }

        public long getNumberOfNodesSequenced() {
            return this.numberOfNodesSequenced.get();
        }

        public long getNumberOfNodesSkipped() {
            return this.numberOfNodesSkipped.get();
        }

        protected void recordNodeSequenced() {
            this.numberOfNodesSequenced.incrementAndGet();
        }

        protected void recordNodeSkipped() {
            this.numberOfNodesSkipped.incrementAndGet();
        }
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.sequencingServiceName, ServiceAdministrator.State.PAUSED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            SequencingService.this.startService();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            SequencingService.this.shutdownService();
        }

        protected boolean doCheckIsTerminated() {
            return SequencingService.this.isServiceTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return SequencingService.this.doAwaitTermination(timeout, unit);
        }
    }

    protected static class DefaultNodeFilter
    implements NodeFilter {
        protected DefaultNodeFilter() {
        }

        public boolean accept(NodeChange nodeChange) {
            return nodeChange.includesEventTypes(1, 4, 16);
        }
    }

    public static interface NodeFilter {
        public boolean accept(NodeChange var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultSelector
    implements Selector {
        protected DefaultSelector() {
        }

        @Override
        public List<Sequencer> selectSequencers(List<Sequencer> sequencers, Node node, NodeChange nodeChange) {
            return sequencers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Selector {
        public List<Sequencer> selectSequencers(List<Sequencer> var1, Node var2, NodeChange var3);
    }
}

