/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Binary;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.sequencer.SequencerContext;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencer;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.mimetype.MimeType;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.sequencer.Sequencer;
import org.jboss.dna.repository.sequencer.SequencerConfig;
import org.jboss.dna.repository.sequencer.SequencerException;
import org.jboss.dna.repository.sequencer.SequencerOutputMap;
import org.jboss.dna.repository.util.JcrExecutionContext;
import org.jboss.dna.repository.util.RepositoryNodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSequencerAdapter
implements Sequencer {
    private SequencerConfig configuration;
    private final StreamSequencer streamSequencer;

    public StreamSequencerAdapter(StreamSequencer streamSequencer) {
        this.streamSequencer = streamSequencer;
    }

    public SequencerConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SequencerConfig configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Node input, String sequencedPropertyName, NodeChange changes, Set<RepositoryNodePath> outputPaths, JcrExecutionContext execContext, Problems problems) throws RepositoryException, SequencerException {
        SequencerOutputMap output;
        block29: {
            Throwable firstError;
            block30: {
                Object var16_17;
                Throwable t222;
                javax.jcr.Property sequencedProperty = null;
                try {
                    sequencedProperty = input.getProperty(sequencedPropertyName);
                }
                catch (PathNotFoundException e) {
                    String msg = RepositoryI18n.unableToFindPropertyForSequencing.text(new Object[]{sequencedPropertyName, input.getPath()});
                    throw new SequencerException(msg, e);
                }
                output = new SequencerOutputMap(execContext.getValueFactories());
                InputStream stream = null;
                firstError = null;
                try {
                    Object var13_15;
                    try {
                        stream = sequencedProperty.getStream();
                        SequencerContext sequencerContext = this.createSequencerContext(input, sequencedProperty, execContext, problems);
                        this.streamSequencer.sequence(stream, (SequencerOutput)output, sequencerContext);
                    }
                    catch (Throwable t3) {
                        block28: {
                            firstError = t3;
                            var13_15 = null;
                            if (stream != null) {
                                try {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable t222) {
                                        if (firstError == null) {
                                            firstError = t222;
                                        }
                                        var16_17 = null;
                                        stream = null;
                                        break block28;
                                    }
                                    var16_17 = null;
                                    stream = null;
                                }
                                catch (Throwable throwable) {
                                    Object var16_19 = null;
                                    stream = null;
                                    throw throwable;
                                }
                            }
                        }
                        if (firstError != null) {
                            throw new SequencerException(firstError);
                        }
                        break block29;
                    }
                    var13_15 = null;
                    if (stream == null) break block30;
                }
                catch (Throwable throwable) {
                    block31: {
                        Object var13_16 = null;
                        if (stream == null) break block31;
                        try {}
                        catch (Throwable throwable2) {
                            Object var16_22 = null;
                            stream = null;
                            throw throwable2;
                        }
                        try {}
                        catch (Throwable t222) {
                            if (firstError == null) {
                                firstError = t222;
                            }
                            Object var16_21 = null;
                            stream = null;
                            break block31;
                        }
                        stream.close();
                        Object var16_20 = null;
                        stream = null;
                    }
                    if (firstError != null) {
                        throw new SequencerException(firstError);
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    stream = null;
                    throw throwable;
                }
                try {}
                catch (Throwable t222) {
                    if (firstError == null) {
                        firstError = t222;
                    }
                    var16_17 = null;
                    stream = null;
                    break block30;
                }
                stream.close();
                var16_17 = null;
                stream = null;
            }
            if (firstError != null) {
                throw new SequencerException(firstError);
            }
        }
        Iterator<RepositoryNodePath> i$ = outputPaths.iterator();
        while (i$.hasNext()) {
            Object var18_31;
            RepositoryNodePath outputPath = i$.next();
            Session session = null;
            try {
                String repositoryWorkspaceName = outputPath.getRepositoryWorkspaceName();
                String nodePath = outputPath.getNodePath();
                session = execContext.getSessionFactory().createSession(repositoryWorkspaceName);
                Node outputNode = execContext.getTools().findOrCreateNode(session, nodePath);
                if (this.saveOutput(outputNode, output, execContext)) {
                    session.save();
                }
                var18_31 = null;
                if (session == null) continue;
            }
            catch (Throwable throwable) {
                var18_31 = null;
                if (session != null) {
                    session.logout();
                }
                throw throwable;
            }
            session.logout();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveOutput(Node outputNode, SequencerOutputMap output, JcrExecutionContext context) throws RepositoryException {
        if (output.isEmpty()) {
            return false;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NamespaceRegistry namespaceRegistry = context.getNamespaceRegistry();
        Path outputNodePath = (Path)pathFactory.create(outputNode.getPath());
        Name jcrPrimaryTypePropertyName = (Name)context.getValueFactories().getNameFactory().create("jcr:primaryType");
        for (SequencerOutputMap.Entry entry : output) {
            Path targetNodePath = entry.getPath();
            Name primaryType = entry.getPrimaryTypeValue();
            Path absolutePath = targetNodePath.isAbsolute() ? targetNodePath : outputNodePath.resolve(targetNodePath);
            Path relativePath = absolutePath.relativeTo(outputNodePath);
            Node targetNode = outputNode;
            int max = relativePath.size();
            for (int i = 0; i != max; ++i) {
                Path.Segment segment = relativePath.getSegment(i);
                String qualifiedName = segment.getString(namespaceRegistry);
                if (targetNode.hasNode(qualifiedName)) {
                    targetNode = targetNode.getNode(qualifiedName);
                } else {
                    if (segment.hasIndex()) {
                        qualifiedName = segment.getName().getString(namespaceRegistry);
                    }
                    targetNode = i == max - 1 && primaryType != null ? targetNode.addNode(qualifiedName, primaryType.getString(namespaceRegistry, Path.NO_OP_ENCODER)) : targetNode.addNode(qualifiedName);
                }
                assert (targetNode != null);
            }
            assert (targetNode != null);
            for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                String propertyName = property.getName().getString(namespaceRegistry, Path.NO_OP_ENCODER);
                Object value = property.getValue();
                if (jcrPrimaryTypePropertyName.equals(property.getName())) {
                    Logger.getLogger(this.getClass()).trace("Skipping property {0}/{1}={2}", new Object[]{targetNode.getPath(), propertyName, value});
                    continue;
                }
                Logger.getLogger(this.getClass()).trace("Writing property {0}/{1}={2}", new Object[]{targetNode.getPath(), propertyName, value});
                if (value instanceof Boolean) {
                    targetNode.setProperty(propertyName, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    targetNode.setProperty(propertyName, (String)value);
                    continue;
                }
                if (value instanceof String[]) {
                    targetNode.setProperty(propertyName, (String[])value);
                    continue;
                }
                if (value instanceof Integer) {
                    targetNode.setProperty(propertyName, (long)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Short) {
                    targetNode.setProperty(propertyName, (long)((Short)value).shortValue());
                    continue;
                }
                if (value instanceof Long) {
                    targetNode.setProperty(propertyName, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    targetNode.setProperty(propertyName, (double)((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    targetNode.setProperty(propertyName, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Binary) {
                    Object var21_25;
                    Binary binaryValue = (Binary)value;
                    try {
                        binaryValue.acquire();
                        targetNode.setProperty(propertyName, binaryValue.getStream());
                        var21_25 = null;
                    }
                    catch (Throwable throwable) {
                        var21_25 = null;
                        binaryValue.release();
                        throw throwable;
                    }
                    binaryValue.release();
                    {
                        continue;
                    }
                }
                if (value instanceof BigDecimal) {
                    targetNode.setProperty(propertyName, ((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof DateTime) {
                    targetNode.setProperty(propertyName, ((DateTime)value).toCalendar());
                    continue;
                }
                if (value instanceof Date) {
                    DateTime instant = (DateTime)context.getValueFactories().getDateFactory().create((Date)value);
                    targetNode.setProperty(propertyName, instant.toCalendar());
                    continue;
                }
                if (value instanceof Calendar) {
                    targetNode.setProperty(propertyName, (Calendar)value);
                    continue;
                }
                if (value instanceof Name) {
                    Name nameValue = (Name)value;
                    String stringValue = nameValue.getString(namespaceRegistry);
                    targetNode.setProperty(propertyName, stringValue);
                    continue;
                }
                if (value instanceof Path) {
                    Path pathToReferencedNode = (Path)value;
                    if (!pathToReferencedNode.isAbsolute()) {
                        pathToReferencedNode = outputNodePath.resolve(pathToReferencedNode);
                    }
                    try {
                        Node referencedNode = outputNode.getNode(pathToReferencedNode.getString());
                        targetNode.setProperty(propertyName, referencedNode);
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        String msg = RepositoryI18n.errorGettingNodeRelativeToNode.text(new Object[]{value, outputNode.getPath()});
                        throw new SequencerException(msg, e);
                    }
                }
                if (value == null) {
                    targetNode.setProperty(propertyName, (String)null);
                    continue;
                }
                String msg = RepositoryI18n.unknownPropertyValueType.text(new Object[]{value, value.getClass().getName()});
                throw new SequencerException(msg);
            }
        }
        return true;
    }

    protected String[] extractMixinTypes(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }

    protected SequencerContext createSequencerContext(Node input, javax.jcr.Property sequencedProperty, ExecutionContext context, Problems problems) throws RepositoryException {
        assert (input != null);
        assert (sequencedProperty != null);
        assert (context != null);
        assert (problems != null);
        ValueFactories factories = context.getValueFactories();
        Path path = (Path)factories.getPathFactory().create(input.getPath());
        Set<Property> props = new HashSet();
        PropertyIterator iter = input.getProperties();
        while (iter.hasNext()) {
            Property prop;
            javax.jcr.Property jcrProp = iter.nextProperty();
            if (jcrProp.getDefinition().isMultiple()) {
                Value[] jcrVals = jcrProp.getValues();
                Object[] vals = new Object[jcrVals.length];
                int ndx = 0;
                for (Value jcrVal : jcrVals) {
                    vals[ndx++] = this.convert(factories, jcrProp.getName(), jcrVal);
                }
                prop = context.getPropertyFactory().create((Name)factories.getNameFactory().create(jcrProp.getName()), vals);
            } else {
                Value jcrVal = jcrProp.getValue();
                Object val = this.convert(factories, jcrProp.getName(), jcrVal);
                prop = context.getPropertyFactory().create((Name)factories.getNameFactory().create(jcrProp.getName()), new Object[]{val});
            }
            props.add(prop);
        }
        props = Collections.unmodifiableSet(props);
        String mimeType = this.getMimeType(sequencedProperty, path.getLastSegment().getName().getLocalName());
        return new SequencerContext(context, path, props, mimeType, problems);
    }

    protected Object convert(ValueFactories factories, String name, Value jcrValue) throws RepositoryException {
        switch (jcrValue.getType()) {
            case 2: {
                return factories.getBinaryFactory().create((Object)jcrValue.getStream());
            }
            case 6: {
                return factories.getBooleanFactory().create(jcrValue.getBoolean());
            }
            case 5: {
                return factories.getDateFactory().create(jcrValue.getDate());
            }
            case 4: {
                return factories.getDoubleFactory().create(jcrValue.getDouble());
            }
            case 3: {
                return factories.getLongFactory().create(jcrValue.getLong());
            }
            case 7: {
                return factories.getNameFactory().create(jcrValue.getString());
            }
            case 8: {
                return factories.getPathFactory().create(jcrValue.getString());
            }
            case 9: {
                return factories.getReferenceFactory().create(jcrValue.getString());
            }
            case 1: {
                return factories.getStringFactory().create(jcrValue.getString());
            }
        }
        throw new RepositoryException(RepositoryI18n.unknownPropertyValueType.text(new Object[]{name, jcrValue.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String getMimeType(javax.jcr.Property sequencedProperty, String name) {
        block12: {
            err = null;
            mimeType = null;
            stream = null;
            stream = sequencedProperty.getStream();
            var6_6 = mimeType = MimeType.of(name, stream);
            var8_8 = null;
            if (stream == null) break block12;
            try {
                stream.close();
            }
            catch (IOException error) {
                if (err != null) break block12;
                err = new SequencerException(error);
            }
        }
        return var6_6;
        catch (Exception error) {
            try {
                err = new SequencerException(error);
                var8_9 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                block13: {
                    var8_10 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException error) {
                            if (err != null) break block13;
                            err = new SequencerException(error);
                        }
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (IOException error) {
                    if (err == null) {
                        err = new SequencerException(error);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
            }
        }
        if (err != null) {
            throw err;
        }
        return mimeType;
    }
}

