/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.util.JcrNamespaceRegistry;
import org.jboss.dna.repository.util.JcrTools;
import org.jboss.dna.repository.util.SessionFactory;

public class JcrExecutionContext
extends ExecutionContext {
    private final String repositoryWorkspaceForNamespaceRegistry;
    private final ClosableSessionFactory sessionFactory;
    private final JcrTools jcrTools;

    public JcrExecutionContext(ExecutionContext context, SessionFactory sessionFactory, String repositoryWorkspaceForNamespaceRegistry) {
        super(context.with((NamespaceRegistry)new JcrNamespaceRegistry(sessionFactory, repositoryWorkspaceForNamespaceRegistry)));
        this.sessionFactory = new ClosableSessionFactory(sessionFactory);
        this.jcrTools = new JcrTools();
        this.repositoryWorkspaceForNamespaceRegistry = repositoryWorkspaceForNamespaceRegistry;
    }

    public JcrExecutionContext(SessionFactory sessionFactory, String repositoryWorkspaceForNamespaceRegistry) {
        this(new ExecutionContext(), sessionFactory, repositoryWorkspaceForNamespaceRegistry);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public JcrTools getTools() {
        return this.jcrTools;
    }

    public JcrExecutionContext clone() {
        return new JcrExecutionContext(this, this.sessionFactory.getDelegateFactory(), this.repositoryWorkspaceForNamespaceRegistry);
    }

    public void close() {
        this.sessionFactory.close();
    }

    protected static class ClosableSessionFactory
    implements SessionFactory {
        private final SessionFactory delegateFactory;
        private final Set<Session> sessions = new HashSet<Session>();
        protected final AtomicBoolean closed = new AtomicBoolean(false);

        protected ClosableSessionFactory(SessionFactory sessionFactory) {
            this.delegateFactory = sessionFactory;
        }

        public SessionFactory getDelegateFactory() {
            return this.delegateFactory;
        }

        public Session createSession(String name) throws RepositoryException {
            if (this.closed.get()) {
                throw new IllegalStateException(RepositoryI18n.executionContextHasBeenClosed.text(new Object[0]));
            }
            Session session = this.delegateFactory.createSession(name);
            if (session != null) {
                this.sessions.add(session);
            }
            return session;
        }

        public synchronized void close() {
            if (this.closed.get()) {
                return;
            }
            this.closed.set(true);
            for (Session session : this.sessions) {
                if (session == null) continue;
                session.logout();
            }
        }
    }
}

