/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.zip;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.graph.sequencer.SequencerContext;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.sequencer.zip.SequencingOutputTestClass;
import org.jboss.dna.sequencer.zip.ZipSequencer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ZipSequencerTest {
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestZip(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToExtractZip() {
        InputStream is = this.getTestZip("testzip.zip");
        ZipSequencer zs = new ZipSequencer();
        SequencingOutputTestClass seqtest = new SequencingOutputTestClass();
        SequencerContext context = (SequencerContext)Mockito.mock(SequencerContext.class);
        zs.sequence(is, (SequencerOutput)seqtest, context);
        Assert.assertThat((Object)seqtest.properties.get(2).getPath(), (Matcher)Is.is((Object)"zip:content/test subfolder/test2.txt/jcr:content"));
    }
}

