/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.zip;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.dna.graph.sequencer.SequencerContext;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencer;

public class ZipSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, SequencerContext context) {
        try {
            ZipInputStream in = new ZipInputStream(stream);
            ZipEntry entry = in.getNextEntry();
            byte[] buf = new byte[1024];
            output.setProperty("zip:content", "jcr:primaryType", new Object[]{"zip:content"});
            while (entry != null) {
                if (entry.isDirectory()) {
                    output.setProperty("zip:content/" + entry.getName(), "jcr:primaryType", new Object[]{"nt:folder"});
                } else {
                    int n;
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:primaryType", new Object[]{"nt:resource"});
                    ByteArrayOutputStream baout = new ByteArrayOutputStream();
                    while ((n = in.read(buf, 0, 1024)) > -1) {
                        baout.write(buf, 0, n);
                    }
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:data", new Object[]{baout.toByteArray()});
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

