/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.interceptor;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ejb.Asynchronous;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.async.impl.interceptor.SecurityActions;
import org.jboss.ejb3.async.spi.AsyncInvocation;
import org.jboss.ejb3.async.spi.AsyncInvocationContext;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;

public class AsynchronousInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(AsynchronousInterceptor.class);

    public AsynchronousInterceptor() {
        log.debug((Object)("Created: " + this));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isAsyncInvocation(invocation)) {
            return this.invokeAsync(invocation);
        }
        return invocation.invokeNext();
    }

    private Future<?> invokeAsync(Invocation invocation) {
        AsyncInvocationContext context = this.getInvocationContext(invocation);
        ExecutorService executorService = context.getAsynchronousExecutor();
        SecurityContext sc = SecurityActions.getSecurityContext();
        Invocation nextInvocation = invocation.copy();
        AsyncInvocationTask asyncTask = new AsyncInvocationTask(nextInvocation, sc);
        Future task = executorService.submit(asyncTask);
        return task;
    }

    private boolean isAsyncInvocation(Invocation invocation) {
        assert (invocation instanceof MethodInvocation) : this.getClass().getName() + " supports only " + MethodInvocation.class.getSimpleName() + ", but has been passed: " + invocation;
        MethodInvocation si = (MethodInvocation)invocation;
        Method actualMethod = si.getActualMethod();
        if (invocation.resolveAnnotation(Asynchronous.class) != null || actualMethod.getReturnType().equals(Future.class)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Intercepted: " + actualMethod));
            }
            return true;
        }
        return false;
    }

    private AsyncInvocationContext getInvocationContext(Invocation invocation) {
        assert (invocation != null) : "Invocation must be specified";
        assert (invocation instanceof AsyncInvocation) : "Invocation " + invocation.toString() + " must be of type " + AsyncInvocation.class.getName();
        AsyncInvocation asyncInvocation = (AsyncInvocation)invocation;
        return asyncInvocation.getAsyncInvocationContext();
    }

    private class AsyncInvocationTask<V>
    implements Callable<V> {
        private final Invocation invocation;
        private final SecurityContext sc;

        public AsyncInvocationTask(Invocation invocation, SecurityContext sc) {
            this.invocation = invocation;
            this.sc = sc;
        }

        @Override
        public V call() throws Exception {
            SecurityContext oldSc = SecurityActions.getSecurityContext();
            try {
                SecurityActions.setSecurityContext(this.sc);
                Object object = this.invocation.invokeNext();
                return (V)object;
            }
            catch (Throwable t) {
                throw new Exception(t);
            }
            finally {
                SecurityActions.setSecurityContext(oldSc);
            }
        }
    }
}

