/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.Future;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.async.impl.remote.r2.RemotableAsyncFutureInvocationHandler;
import org.jboss.ejb3.async.spi.container.remote.RemotableAsyncInvocationProcessor;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.logging.Logger;

public class RemotableFutureInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(RemotableFutureInterceptor.class);

    public RemotableFutureInterceptor() {
        log.debug((Object)("Created: " + this));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object returnValue = invocation.invokeNext();
        if (this.isRemoteInvocation(invocation) && returnValue instanceof Future) {
            Future futureReturnValue = (Future)returnValue;
            UUID uuid = UUID.randomUUID();
            this.getInvocationProcessor(invocation).getRemoteAsyncTaskRegistry().put((Object)uuid, (Object)futureReturnValue);
            Class[] interfaces = new Class[]{Future.class};
            RemotableAsyncFutureInvocationHandler handler = new RemotableAsyncFutureInvocationHandler();
            Future remotableFuture = (Future)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)((Object)handler));
            return remotableFuture;
        }
        return returnValue;
    }

    private boolean isRemoteInvocation(Invocation invocation) {
        assert (invocation instanceof MethodInvocation) : this.getClass().getName() + " supports only " + MethodInvocation.class.getSimpleName() + ", but has been passed: " + invocation;
        Object remotingMetadata = invocation.getMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR");
        return remotingMetadata != null;
    }

    private RemotableAsyncInvocationProcessor getInvocationProcessor(Invocation invocation) {
        return (RemotableAsyncInvocationProcessor)((ManagedObjectAdvisor)invocation.getAdvisor()).getContainer();
    }
}

