/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ejb.Asynchronous;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.async.impl.ClientExecutorService;
import org.jboss.ejb3.async.impl.interceptor.SecurityActions;
import org.jboss.ejb3.async.spi.AsyncInvocation;
import org.jboss.ejb3.async.spi.AsyncInvocationContext;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;

public class AsynchronousInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AsynchronousInterceptor.class);
    private static final String INVOCATION_METADATA_TAG = "ASYNC";
    private static final String INVOCATION_METADATA_ATTR = "BEEN_HERE";
    private static final String INVOCATION_METADATA_VALUE = Boolean.TRUE.toString();

    public AsynchronousInterceptor() {
        log.debug((Object)("Created: " + this));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isAsyncInvocation(invocation)) {
            return this.invokeAsync(invocation);
        }
        return invocation.invokeNext();
    }

    private Future<?> invokeAsync(Invocation invocation) {
        ExecutorService executorService = this.getAsyncExecutor(invocation);
        SecurityContext sc = SecurityActions.getSecurityContext();
        Invocation nextInvocation = invocation.copy();
        nextInvocation.getMetaData().addMetaData((Object)INVOCATION_METADATA_TAG, (Object)INVOCATION_METADATA_ATTR, (Object)INVOCATION_METADATA_VALUE);
        AsyncInvocationTask asyncTask = new AsyncInvocationTask(nextInvocation, sc);
        Future task = executorService.submit(asyncTask);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Submitting async invocation " + invocation + " via " + executorService));
        }
        return task;
    }

    private boolean isAsyncInvocation(Invocation invocation) {
        assert (invocation instanceof MethodInvocation) : this.getClass().getName() + " supports only " + MethodInvocation.class.getSimpleName() + ", but has been passed: " + invocation;
        MethodInvocation si = (MethodInvocation)invocation;
        String beenHere = (String)invocation.getMetaData().getMetaData((Object)INVOCATION_METADATA_TAG, (Object)INVOCATION_METADATA_ATTR);
        if (beenHere != null && beenHere.equals(INVOCATION_METADATA_VALUE)) {
            return false;
        }
        Method actualMethod = si.getActualMethod();
        if (invocation.resolveAnnotation(Asynchronous.class) != null || actualMethod.getReturnType().isAssignableFrom(Future.class) || actualMethod.getClass().getAnnotation(Asynchronous.class) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Dispatching as @Asynchronous: " + actualMethod));
            }
            return true;
        }
        return false;
    }

    private ExecutorService getAsyncExecutor(Invocation invocation) {
        assert (invocation != null) : "Invocation must be specified";
        if (invocation instanceof AsyncInvocation) {
            AsyncInvocation asyncInvocation = (AsyncInvocation)invocation;
            AsyncInvocationContext context = asyncInvocation.getAsyncInvocationContext();
            assert (context != null) : "async invocation context of " + invocation + " was null";
            ExecutorService es = context.getAsynchronousExecutor();
            assert (es != null) : ExecutorService.class.getSimpleName() + " associated with " + context + " was null";
            return es;
        }
        return ClientExecutorService.INSTANCE;
    }

    private class AsyncInvocationTask<V>
    implements Callable<V> {
        private final Invocation invocation;
        private final SecurityContext sc;

        public AsyncInvocationTask(Invocation invocation, SecurityContext sc) {
            this.invocation = invocation;
            this.sc = sc;
        }

        @Override
        public V call() throws Exception {
            SecurityContext oldSc = SecurityActions.getSecurityContext();
            try {
                SecurityActions.setSecurityContext(this.sc);
                Object object = this.invocation.invokeNext();
                return (V)object;
            }
            catch (Throwable t) {
                throw new Exception(t);
            }
            finally {
                SecurityActions.setSecurityContext(oldSc);
            }
        }
    }
}

