/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.util.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb3.async.impl.util.concurrent.LocalJvmSerializableFutureWrapper;
import org.jboss.ejb3.async.impl.util.concurrent.ResultUnwrappingFuture;

public class ResultUnwrappingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    public ResultUnwrappingExecutorService(ExecutorService delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate " + ExecutorService.class.getSimpleName() + " must be specified");
        }
        this.delegate = delegate;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ResultUnwrappingFuture<T> ftask = new ResultUnwrappingFuture<T>(task);
        this.delegate.execute(ftask);
        return new LocalJvmSerializableFutureWrapper<T>(ftask);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        ResultUnwrappingFuture<T> ftask = new ResultUnwrappingFuture<T>(task, result);
        this.delegate.execute(ftask);
        return new LocalJvmSerializableFutureWrapper<T>(ftask);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ResultUnwrappingFuture<Object> ftask = new ResultUnwrappingFuture<Object>(task, null);
        this.delegate.execute(ftask);
        return new LocalJvmSerializableFutureWrapper<Object>(ftask);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public void execute(Runnable command) {
    }
}

