/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.interceptor;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.async.impl.lang.ThreadLocalStack;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.logging.Logger;

public class CurrentAsyncInvocation {
    private static final Logger log = Logger.getLogger(CurrentAsyncInvocation.class);
    private static final ThreadLocalStack<AsyncInvocationId> CURRENT_EXECUTING_INVOCATIONS = new ThreadLocalStack();

    private CurrentAsyncInvocation() {
        throw new UnsupportedOperationException("No instances");
    }

    public static AsyncInvocationId getCurrentAsyncInvocationId(Invocation invocation) {
        assert (invocation != null) : "Invocation must be specified";
        AsyncInvocationId current = CurrentAsyncInvocation.getCurrentAsyncInvocationId();
        if (current == null) {
            current = (AsyncInvocationId)invocation.getMetaData((Object)"org.jboss.ejb3.async", (Object)"UUID");
        }
        return current;
    }

    public static AsyncInvocationId getCurrentAsyncInvocationId() {
        return CURRENT_EXECUTING_INVOCATIONS.get();
    }

    public static void markCurrentInvocationOnThread(AsyncInvocationId uuid) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Putting current invocation on Thread " + Thread.currentThread() + ":  " + uuid));
        }
        CURRENT_EXECUTING_INVOCATIONS.push(uuid);
    }

    public static void markCurrentInvocation(AsyncInvocationId uuid, Invocation invocation) {
        assert (invocation != null) : "Invocation must be specified";
        CurrentAsyncInvocation.markCurrentInvocationOnThread(uuid);
        invocation.getMetaData().addMetaData((Object)"org.jboss.ejb3.async", (Object)"UUID", (Object)uuid);
    }

    public static AsyncInvocationId unmarkCurrentInvocationFromThread() {
        AsyncInvocationId id = CURRENT_EXECUTING_INVOCATIONS.pop();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing current invocation from Thread " + Thread.currentThread() + ":  " + id));
        }
        return id;
    }

    public static AsyncInvocationId unmarkCurrentInvocation(Invocation invocation) {
        AsyncInvocationId current = CurrentAsyncInvocation.unmarkCurrentInvocationFromThread();
        invocation.getMetaData().removeMetaData((Object)"org.jboss.ejb3.async", (Object)"UUID");
        return current;
    }
}

