/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.concurrency.aop.interceptor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.concurrency.impl.EJBReadWriteLock;
import org.jboss.logging.Logger;

public class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private static Logger logger = Logger.getLogger(ContainerManagedConcurrencyInterceptor.class);
    private ReadWriteLock readWriteLock = new EJBReadWriteLock();
    private static final long DEFAULT_MAX_TIMEOUT_VALUE = 5L;
    private static final TimeUnit DEFAULT_MAX_TIMEOUT_UNIT = TimeUnit.MINUTES;

    private AccessTimeout getAccessTimeout(Invocation invocation) {
        AccessTimeout timeout = (AccessTimeout)invocation.resolveAnnotation(AccessTimeout.class);
        if (timeout == null) {
            timeout = (AccessTimeout)invocation.resolveClassAnnotation(AccessTimeout.class);
        }
        return timeout;
    }

    private java.util.concurrent.locks.Lock getLock(Invocation invocation) {
        LockType lockType = this.getLockType(invocation);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw new IllegalStateException("Illegal lock type " + lockType + " on " + invocation);
    }

    private LockType getLockType(Invocation invocation) {
        Lock lock = (Lock)invocation.resolveAnnotation(Lock.class);
        if (lock == null) {
            lock = (Lock)invocation.resolveClassAnnotation(Lock.class);
        }
        if (lock == null) {
            return LockType.WRITE;
        }
        return lock.value();
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        boolean success;
        java.util.concurrent.locks.Lock lock = this.getLock(invocation);
        long time = 5L;
        TimeUnit unit = DEFAULT_MAX_TIMEOUT_UNIT;
        AccessTimeout timeout = this.getAccessTimeout(invocation);
        if (timeout != null) {
            if (timeout.value() < 0L) {
                logger.info((Object)("Ignoring a negative @AccessTimeout value: " + timeout.value() + " and timeout unit: " + timeout.unit().name() + ". Will default to timeout value: " + 5L + " and timeout unit: " + DEFAULT_MAX_TIMEOUT_UNIT.name()));
            } else {
                time = timeout.value();
                unit = timeout.unit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on " + invocation + " - could not obtain lock within " + time + unit.name());
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

