/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.effigy.common;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ejb3.effigy.ApplicationExceptionEffigy;
import org.jboss.ejb3.effigy.EnterpriseBeanEffigy;
import org.jboss.ejb3.effigy.common.JBossApplicationExceptionEffigy;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;

public class JBossEnterpriseBeanEffigy
implements EnterpriseBeanEffigy {
    private static final ApplicationExceptionEffigy NULL = new JBossApplicationExceptionEffigy();
    private JBossEnterpriseBeanMetaData beanMetaData;
    private Class<?> ejbClass;
    private Collection<ApplicationExceptionEffigy> applicationExceptionEffigies;
    private Map<Class<?>, ApplicationExceptionEffigy> applicationExceptionEffigyMap = new ConcurrentHashMap();

    public JBossEnterpriseBeanEffigy(ClassLoader classLoader, JBossEnterpriseBeanMetaData beanMetaData) throws ClassNotFoundException {
        this.beanMetaData = beanMetaData;
        this.ejbClass = classLoader.loadClass(beanMetaData.getEjbClass());
        this.applicationExceptionEffigies = this.createApplicationExceptionEffigies(classLoader, beanMetaData.getEjbJarMetaData().getAssemblyDescriptor());
    }

    private Collection<ApplicationExceptionEffigy> createApplicationExceptionEffigies(ClassLoader classLoader, JBossAssemblyDescriptorMetaData assemblyDescriptorMetaData) throws ClassNotFoundException {
        if (assemblyDescriptorMetaData == null) {
            return null;
        }
        ApplicationExceptionsMetaData applicationExceptionsMetaData = assemblyDescriptorMetaData.getApplicationExceptions();
        if (applicationExceptionsMetaData == null) {
            return null;
        }
        LinkedList<ApplicationExceptionEffigy> applicationExceptionEffigies = new LinkedList<ApplicationExceptionEffigy>();
        for (ApplicationExceptionMetaData applicationExceptionMetaData : applicationExceptionsMetaData) {
            applicationExceptionEffigies.add(this.createApplicationExceptionEffigy(classLoader, applicationExceptionMetaData));
        }
        return applicationExceptionEffigies;
    }

    protected ApplicationExceptionEffigy createApplicationExceptionEffigy(ClassLoader classLoader, ApplicationExceptionMetaData metaData) throws ClassNotFoundException {
        return new JBossApplicationExceptionEffigy(classLoader, metaData);
    }

    private ApplicationExceptionEffigy findApplicationException(Class<?> exceptionClass) {
        for (ApplicationExceptionEffigy applicationExceptionEffigy : this.applicationExceptionEffigies) {
            if (!applicationExceptionEffigy.getExceptionClass().equals(exceptionClass)) continue;
            return applicationExceptionEffigy;
        }
        Class<?> superclass = exceptionClass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.findApplicationException(exceptionClass.getSuperclass());
    }

    public ApplicationExceptionEffigy getApplicationException(Class<?> exceptionClass) {
        if (this.applicationExceptionEffigies == null) {
            return null;
        }
        ApplicationExceptionEffigy applicationExceptionEffigy = this.applicationExceptionEffigyMap.get(exceptionClass);
        if (applicationExceptionEffigy == NULL) {
            return null;
        }
        if (applicationExceptionEffigy != null) {
            return applicationExceptionEffigy;
        }
        applicationExceptionEffigy = this.findApplicationException(exceptionClass);
        if (applicationExceptionEffigy == null) {
            this.applicationExceptionEffigyMap.put(exceptionClass, NULL);
        } else {
            this.applicationExceptionEffigyMap.put(exceptionClass, applicationExceptionEffigy);
        }
        return applicationExceptionEffigy;
    }

    protected JBossEnterpriseBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public Class<?> getEjbClass() {
        return this.ejbClass;
    }

    public String getName() {
        return this.beanMetaData.getEjbName();
    }
}

