/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.effigy.common;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jboss.ejb3.effigy.AccessTimeoutEffigy;
import org.jboss.ejb3.effigy.SessionBeanEffigy;
import org.jboss.ejb3.effigy.StatefulTimeoutEffigy;
import org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSessionBeanEffigy
extends JBossEnterpriseBeanEffigy
implements SessionBeanEffigy {
    public JBossSessionBeanEffigy(ClassLoader classLoader, JBossSessionBeanMetaData beanMetaData) throws ClassNotFoundException {
        super(classLoader, (JBossEnterpriseBeanMetaData)beanMetaData);
    }

    public AccessTimeoutEffigy getAccessTimeout(Method method) {
        return null;
    }

    public Method getAfterBeginMethod() {
        return null;
    }

    public Method getAfterCompletionMethod() {
        return null;
    }

    public Method getBeforeCompletionMethod() {
        return null;
    }

    public StatefulTimeoutEffigy getStatefulTimeout() {
        return null;
    }

    @Override
    protected Set<Class<?>> getAllViews(ClassLoader cl) {
        JBossSessionBeanMetaData sessionBeanMetaData = (JBossSessionBeanMetaData)this.getBeanMetaData();
        HashSet views = new HashSet();
        try {
            String serviceEndpoint;
            BusinessRemotesMetaData businessRemotes;
            BusinessLocalsMetaData businessLocals;
            String local;
            String localHome;
            String remote;
            String home = sessionBeanMetaData.getHome();
            if (home != null) {
                views.add(cl.loadClass(home));
            }
            if ((remote = sessionBeanMetaData.getRemote()) != null) {
                views.add(cl.loadClass(remote));
            }
            if ((localHome = sessionBeanMetaData.getLocalHome()) != null) {
                views.add(cl.loadClass(localHome));
            }
            if ((local = sessionBeanMetaData.getLocal()) != null) {
                views.add(cl.loadClass(local));
            }
            if ((businessLocals = sessionBeanMetaData.getBusinessLocals()) != null) {
                for (String businessLocal : businessLocals) {
                    views.add(cl.loadClass(businessLocal));
                }
            }
            if ((businessRemotes = sessionBeanMetaData.getBusinessRemotes()) != null) {
                for (String businessRemote : businessRemotes) {
                    views.add(cl.loadClass(businessRemote));
                }
            }
            if ((serviceEndpoint = sessionBeanMetaData.getServiceEndpoint()) != null) {
                views.add(cl.loadClass(serviceEndpoint));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        return views;
    }

    @Override
    protected Class<?> getMethodInterface(ClassLoader cl, MethodInterfaceType methodIntf) throws ClassNotFoundException {
        JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)this.getBeanMetaData();
        String className = null;
        if (methodIntf == null) {
            return this.getEjbClass();
        }
        switch (methodIntf) {
            case Home: {
                String home = sessionBean.getHome();
                if (home == null || home.trim().isEmpty()) {
                    return null;
                }
                className = home;
                break;
            }
            case Local: {
                String local = sessionBean.getLocal();
                if (local == null || local.trim().isEmpty()) {
                    return null;
                }
                className = local;
                break;
            }
            case LocalHome: {
                String localHome = sessionBean.getLocalHome();
                if (localHome == null || localHome.isEmpty()) {
                    return null;
                }
                className = localHome;
                break;
            }
            case Remote: {
                String remote = sessionBean.getRemote();
                if (remote == null || remote.isEmpty()) {
                    return null;
                }
                className = remote;
                break;
            }
            case ServiceEndpoint: {
                String serviceEndPoint = sessionBean.getServiceEndpoint();
                if (serviceEndPoint == null || serviceEndPoint.isEmpty()) {
                    return null;
                }
                className = serviceEndPoint;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown method interface type: " + methodIntf);
            }
        }
        return cl.loadClass(className);
    }
}

