/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.StatefulObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPassivationCache<T extends Identifiable>
implements Cache<T> {
    private StatefulObjectFactory<T> factory;
    private Map<Serializable, T> cacheMap;
    private AtomicInteger createCount = new AtomicInteger(0);
    private AtomicInteger removeCount = new AtomicInteger(0);
    private boolean running;

    public NoPassivationCache() {
        this.cacheMap = new HashMap<Serializable, T>();
    }

    @Override
    public void start() {
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Map<Serializable, T> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.clear();
        }
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() {
        try {
            Identifiable instance = (Identifiable)this.factory.createInstance();
            this.createCount.incrementAndGet();
            Map<Serializable, T> map = this.cacheMap;
            synchronized (map) {
                this.cacheMap.put(instance.getId(), instance);
            }
            return (T)instance;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public void discard(Serializable key) {
        this.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Serializable key) throws EJBException {
        Map<Serializable, T> map = this.cacheMap;
        synchronized (map) {
            Identifiable instance = (Identifiable)this.cacheMap.get(key);
            if (instance == null) {
                throw new NoSuchEJBException("Could not find Stateful bean: " + key);
            }
            return (T)instance;
        }
    }

    @Override
    public void release(T instance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Serializable key) {
        Identifiable instance;
        Map<Serializable, T> map = this.cacheMap;
        synchronized (map) {
            instance = (Identifiable)this.cacheMap.remove(key);
            if (instance == null) {
                throw new NoSuchEJBException("Could not find Stateful bean: " + key);
            }
        }
        this.removeCount.incrementAndGet();
        this.factory.destroyInstance(instance);
    }

    public int getCacheSize() {
        return this.cacheMap.size();
    }

    public int getTotalSize() {
        return this.cacheMap.size();
    }

    public int getCreateCount() {
        return this.createCount.intValue();
    }

    public int getPassivatedCount() {
        return 0;
    }

    public int getRemoveCount() {
        return this.removeCount.intValue();
    }

    public int getAvailableCount() {
        int maxSize = this.getMaxSize();
        if (maxSize < 0) {
            return maxSize;
        }
        int currentSize = this.getCurrentSize();
        int available = maxSize - currentSize;
        return available;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getCurrentSize() {
        return this.cacheMap.size();
    }

    public boolean isStarted() {
        return this.running;
    }

    @Override
    public void setStatefulObjectFactory(StatefulObjectFactory<T> factory) {
        this.factory = factory;
    }
}

