/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.LongevityCache;
import org.jboss.ejb3.cache.StatefulObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLongevityCache<T extends Identifiable>
implements LongevityCache<T> {
    private final Cache<T> delegate;
    private final Map<Object, Entry> cache;

    public SimpleLongevityCache(Cache<T> delegate) {
        assert (delegate != null) : "delegate is null";
        this.delegate = delegate;
        this.cache = new HashMap<Object, Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(T obj) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(obj.getId());
            if (entry.state != State.IN_OPERATION) {
                throw new IllegalStateException("entry " + entry + " is not in operation");
            }
            entry.state = State.FINISHED;
            entry.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() {
        T obj = this.delegate.create();
        Entry entry = new Entry(this, obj);
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.put(obj.getId(), entry);
        }
        return obj;
    }

    @Override
    public void discard(Serializable key) {
        this.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Serializable key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null) {
                T obj = this.delegate.get(key);
                entry = new Entry(this, obj);
                this.cache.put(obj.getId(), entry);
                return obj;
            }
            if (entry.state != State.FINISHED) {
                throw new IllegalStateException("entry " + entry + " is not finished");
            }
            entry.state = State.IN_OPERATION;
            entry.lastUsed = System.currentTimeMillis();
            return entry.obj;
        }
    }

    public T peek(Serializable key) throws NoSuchEJBException {
        return this.delegate.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Serializable key = obj.getId();
            Entry entry = this.cache.get(key);
            if (entry.state != State.FINISHED) {
                throw new IllegalStateException("entry " + entry + " is not finished");
            }
            this.delegate.release(obj);
            this.cache.remove(key);
        }
    }

    @Override
    public void remove(Serializable key) {
        this.delegate.remove(key);
    }

    @Override
    public void setStatefulObjectFactory(StatefulObjectFactory<T> factory) {
        this.delegate.setStatefulObjectFactory(factory);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        long lastUsed;
        T obj;
        State state;
        final /* synthetic */ SimpleLongevityCache this$0;

        Entry(T obj) {
            this.this$0 = var1_1;
            assert (obj != null) : "obj is null";
            this.lastUsed = System.currentTimeMillis();
            this.obj = obj;
            this.state = State.IN_OPERATION;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        FINISHED,
        IN_OPERATION;

    }
}

