/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.ObjectStore;
import org.jboss.ejb3.cache.PassivatingCache;
import org.jboss.ejb3.cache.PassivationManager;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.ejb3.cache.grouped.GroupedPassivatingCache;
import org.jboss.ejb3.cache.grouped.PassivationGroup;
import org.jboss.ejb3.cache.impl.PassivationGroupImpl;
import org.jboss.ejb3.cache.impl.SimplePassivatingCache;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedPassivatingCacheImpl<T extends Identifiable & Serializable>
implements GroupedPassivatingCache<T> {
    private static final Logger log = Logger.getLogger(GroupedPassivatingCacheImpl.class);
    private StatefulObjectFactory<T> factory;
    private final PassivatingCache<PassivationGroup> groupCache;
    private final SimplePassivatingCache<Entry> delegate;
    private final Map<Serializable, Entry> storage = new HashMap<Serializable, Entry>();

    public GroupedPassivatingCacheImpl(PassivationManager<T> passivationManager, ObjectStore<T> store, PassivatingCache<PassivationGroup> groupCache) {
        assert (groupCache != null) : "groupCache is null";
        assert (passivationManager != null) : "passivationManager is null";
        this.groupCache = groupCache;
        EntryContainer container = new EntryContainer(passivationManager, store);
        this.delegate = new SimplePassivatingCache<Entry>(container, container);
        this.delegate.setStatefulObjectFactory(container);
    }

    @Override
    public void passivate(Object key) {
        this.delegate.passivate(key);
    }

    @Override
    public T create() {
        return this.delegate.create().obj;
    }

    @Override
    public void discard(Serializable key) {
        this.remove(key);
    }

    @Override
    public T get(Serializable key) throws NoSuchEJBException {
        return this.delegate.get((Serializable)key).obj;
    }

    public T peek(Serializable key) throws NoSuchEJBException {
        return this.delegate.peek((Object)key).obj;
    }

    @Override
    public void release(T obj) {
        this.delegate.releaseByKey(obj.getId());
    }

    @Override
    public void remove(Serializable key) {
        this.delegate.remove(key);
    }

    @Override
    public void setGroup(T obj, PassivationGroup group) {
        Serializable key = obj.getId();
        Entry entry = this.delegate.peek(key);
        if (entry.group != null) {
            throw new IllegalStateException("object " + key + " already associated with a passivation group");
        }
        entry.group = (PassivationGroupImpl)group;
        entry.groupId = group.getId();
        entry.group.addMember(key, entry);
    }

    public void setName(String name) {
        this.delegate.setName(name + "-delegate");
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    @Override
    public void setStatefulObjectFactory(StatefulObjectFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryContainer
    implements StatefulObjectFactory<Entry>,
    PassivationManager<Entry>,
    ObjectStore<Entry> {
        private final PassivationManager<T> passivationManager;
        private final ObjectStore<T> store;

        EntryContainer(PassivationManager<T> passivationManager, ObjectStore<T> store) {
            this.passivationManager = passivationManager;
            this.store = store;
        }

        @Override
        public Entry createInstance() {
            return new Entry(GroupedPassivatingCacheImpl.this, (Identifiable)GroupedPassivatingCacheImpl.this.factory.createInstance());
        }

        @Override
        public void destroyInstance(Entry entry) {
            GroupedPassivatingCacheImpl.this.factory.destroyInstance(entry.obj);
        }

        @Override
        public Entry load(Object key) {
            Entry entry = (Entry)GroupedPassivatingCacheImpl.this.storage.get(key);
            if (entry != null) {
                log.trace((Object)("entry = " + entry));
                return entry;
            }
            Object obj = this.store.load(key);
            if (obj == null) {
                return null;
            }
            return new Entry(GroupedPassivatingCacheImpl.this, obj);
        }

        @Override
        public void postActivate(Entry entry) {
            log.trace((Object)("post activate " + entry));
            if (entry.obj == null) {
                if (entry.group == null) {
                    entry.group = (PassivationGroupImpl)GroupedPassivatingCacheImpl.this.groupCache.get(entry.groupId);
                }
                entry.obj = (Identifiable)entry.group.getMember(entry.id);
            }
            this.passivationManager.postActivate((Serializable)entry.obj);
        }

        @Override
        public void prePassivate(Entry entry) {
            log.trace((Object)("pre passivate " + entry));
            this.passivationManager.prePassivate((Serializable)entry.obj);
            if (entry.group != null) {
                entry.group.removeActive(entry.id);
                entry.group.prePassivate();
                GroupedPassivatingCacheImpl.this.groupCache.passivate(entry.groupId);
                entry.group = null;
                entry.obj = null;
            }
        }

        @Override
        public void store(Entry entry) {
            log.trace((Object)("store " + entry));
            if (entry.groupId == null) {
                this.store.store(entry.obj);
            } else {
                GroupedPassivatingCacheImpl.this.storage.put(entry.id, entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry
    implements Identifiable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Serializable id;
        T obj;
        PassivationGroupImpl group;
        Serializable groupId;
        final /* synthetic */ GroupedPassivatingCacheImpl this$0;

        Entry(T obj) {
            this.this$0 = var1_1;
            assert (obj != null) : "obj is null";
            this.obj = obj;
            this.id = obj.getId();
        }

        @Override
        public Serializable getId() {
            return this.id;
        }

        void passivate() {
            this.group = null;
            this.this$0.delegate.passivate(this.id);
            this.obj = null;
        }

        public String toString() {
            return super.toString() + "{id=" + this.id + ",obj=" + this.obj + ",groupId=" + this.groupId + ",group=" + this.group + "}";
        }
    }
}

