/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.proxy.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.ejb3.common.proxy.spi.ChainableProcessor;

public class ChainedProcessingInvocationHandler
implements InvocationHandler {
    private Object delegate;
    private ChainableProcessor[] processorChain;
    private int nextHandlerIndex = 0;

    public ChainedProcessingInvocationHandler(Object delegate, ChainableProcessor processor) {
        this(delegate, new ChainableProcessor[]{processor});
    }

    public ChainedProcessingInvocationHandler(Object delegate, ChainableProcessor[] handlerChain) {
        assert (delegate != null) : "Requiste delegate was not supplied";
        this.setDelegate(delegate);
        this.setHandlerChain(handlerChain);
    }

    public Object invokeNext(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        if (this.getHandlerChain().length <= this.getNextHandlerIndex()) {
            Object delegate = this.getDelegate();
            assert (delegate != null) : "Requiste delegate was not supplied";
            assert (method.getDeclaringClass().isAssignableFrom(delegate.getClass()));
            this.reset();
            return method.invoke(delegate, args);
        }
        System.out.println("*");
        returnValue = this.getHandlerChain()[this.nextHandlerIndex++].invoke(this, proxy, method, args);
        return returnValue;
    }

    public void reset() {
        this.nextHandlerIndex = 0;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeNext(proxy, method, args);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    protected ChainableProcessor[] getHandlerChain() {
        return this.processorChain == null ? new ChainableProcessor[]{} : this.processorChain;
    }

    protected void setHandlerChain(ChainableProcessor[] handlerChain) {
        this.processorChain = handlerChain;
    }

    protected int getNextHandlerIndex() {
        return this.nextHandlerIndex;
    }
}

