/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.kernel;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.graph.GraphController;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.ejb3.common.kernel.Handle;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;

public abstract class AbstractHandle
implements Handle {
    private Object name;
    private ControllerState state;

    protected AbstractHandle(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    @Override
    public Object getBean(Kernel kernel) throws Throwable {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        KernelController controller = kernel.getController();
        if (!(controller instanceof GraphController)) {
            throw new IllegalArgumentException("Controller is not GraphController instance: " + controller);
        }
        GraphController gc = (GraphController)GraphController.class.cast(controller);
        return gc.getContext(this.name, this.state, this.getSearchInfo());
    }

    protected abstract SearchInfo getSearchInfo();

    public void setState(ControllerState state) {
        this.state = state;
    }
}

