/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.ejb.IEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JBossServicePolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JBossSessionPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JbossEntityPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.process.chain.ProcessorChain;
import org.jboss.metadata.process.chain.ejb.jboss.JBossMetaDataProcessorChain;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.ClusterConfigDefaultValueProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.JBossMetaDataValidatorChainProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.SetDefaultLocalBusinessInterfaceProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.SetExplicitLocalJndiNameProcessor;

public class MetadataUtil {
    private static final Logger log = Logger.getLogger(MetadataUtil.class);

    private MetadataUtil() {
    }

    public static Collection<JBossMetaDataProcessor<JBossMetaData>> getPostMergeMetadataProcessors(ClassLoader cl) {
        ArrayList<JBossMetaDataProcessor<JBossMetaData>> processors = new ArrayList<JBossMetaDataProcessor<JBossMetaData>>();
        processors.add((JBossMetaDataProcessor<JBossMetaData>)new SetDefaultLocalBusinessInterfaceProcessor(cl));
        processors.add((JBossMetaDataProcessor<JBossMetaData>)ClusterConfigDefaultValueProcessor.INSTANCE);
        processors.add((JBossMetaDataProcessor<JBossMetaData>)SetExplicitLocalJndiNameProcessor.INSTANCE);
        processors.add((JBossMetaDataProcessor<JBossMetaData>)JBossMetaDataValidatorChainProcessor.INSTANCE);
        return processors;
    }

    public static ProcessorChain<JBossMetaData> getPostMergeMetadataProcessorChain(ClassLoader cl) {
        JBossMetaDataProcessorChain chain = new JBossMetaDataProcessorChain();
        StringBuffer logMessage = new StringBuffer("Creating ");
        logMessage.append(ProcessorChain.class.getSimpleName());
        logMessage.append(" with the following Processors:");
        Collection<JBossMetaDataProcessor<JBossMetaData>> processors = MetadataUtil.getPostMergeMetadataProcessors(cl);
        if (processors != null) {
            for (JBossMetaDataProcessor<JBossMetaData> processor : processors) {
                chain.addProcessor(processor);
                logMessage.append(" ");
                logMessage.append(processor);
            }
        }
        log.debug((Object)logMessage.toString());
        return chain;
    }

    public static void decorateEjbsWithJndiPolicy(JBossMetaData md, ClassLoader cl) {
        HashMap<JBossEnterpriseBeanMetaData, JBossSessionPolicyDecorator> beansToReplace = new HashMap<JBossEnterpriseBeanMetaData, JBossSessionPolicyDecorator>();
        String mdJndiPolicyName = md.getJndiBindingPolicy();
        if (mdJndiPolicyName != null && mdJndiPolicyName.trim().length() == 0) {
            mdJndiPolicyName = null;
        }
        if (mdJndiPolicyName != null) {
            log.debug((Object)(JBossMetaData.class.getSimpleName() + " " + md + " has defined " + DefaultJndiBindingPolicy.class.getSimpleName() + " \"" + mdJndiPolicyName + "\""));
        }
        JBossEnterpriseBeansMetaData beans = md.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            JBossSessionPolicyDecorator decoratedBean = null;
            DefaultJndiBindingPolicy policy = MetadataUtil.getJndiBindingPolicy(bean, mdJndiPolicyName, cl);
            if (bean.isSession() && !bean.isService()) {
                assert (bean instanceof JBossSessionBeanMetaData) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " representing as Session Bean is not castable to " + JBossSessionBeanMetaData.class.getName();
                JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)bean;
                decoratedBean = new JBossSessionPolicyDecorator(sessionBean, policy);
            }
            if (bean.isService()) {
                assert (bean instanceof JBossServiceBeanMetaData) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " representing as @Service Bean is not castable to " + JBossServiceBeanMetaData.class.getName();
                JBossServiceBeanMetaData serviceBean = (JBossServiceBeanMetaData)bean;
                decoratedBean = new JBossServicePolicyDecorator(serviceBean, policy);
            }
            if (bean.isEntity()) {
                assert (bean instanceof JBossEntityBeanMetaData) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " representing as Entity Bean is not castable to " + JBossEntityBeanMetaData.class.getName();
                JBossEntityBeanMetaData entityBean = (JBossEntityBeanMetaData)bean;
                decoratedBean = new JbossEntityPolicyDecorator(entityBean, policy);
            }
            if (decoratedBean == null) continue;
            beansToReplace.put(bean, decoratedBean);
        }
        for (JBossEnterpriseBeanMetaData beanToReplace : beansToReplace.keySet()) {
            JBossEnterpriseBeanMetaData beanToReplaceWith = (JBossEnterpriseBeanMetaData)beansToReplace.get(beanToReplace);
            boolean removed = beans.remove((Object)beanToReplace);
            assert (removed) : "Remove operation of " + beanToReplace + " from " + beans + " resulted in no action";
            beans.add((IEnterpriseBeanMetaData)beanToReplaceWith);
            log.debug((Object)("Replaced " + beanToReplace.getEjbName() + " with decorated instance fit with " + DefaultJndiBindingPolicy.class.getSimpleName()));
        }
    }

    protected static DefaultJndiBindingPolicy getJndiBindingPolicy(JBossEnterpriseBeanMetaData md, String deployableUnitDefaultJndiPolicyClassName, ClassLoader cl) {
        String jndiPolicyName;
        BasicJndiBindingPolicy policy = null;
        String beanJndiPolicyName = md.getJndiBindingPolicy();
        if (beanJndiPolicyName != null && beanJndiPolicyName.trim().length() == 0) {
            beanJndiPolicyName = null;
        }
        if (beanJndiPolicyName != null) {
            log.debug((Object)("Session EJB " + md.getEjbName() + " has defined " + DefaultJndiBindingPolicy.class.getSimpleName() + " of \"" + beanJndiPolicyName));
        }
        String string = jndiPolicyName = deployableUnitDefaultJndiPolicyClassName != null ? deployableUnitDefaultJndiPolicyClassName : beanJndiPolicyName;
        if (jndiPolicyName != null) {
            Class<?> policyClass = null;
            try {
                policyClass = Class.forName(jndiPolicyName, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not find defined JNDI Binding Policy Class: " + jndiPolicyName, cnfe);
            }
            try {
                policy = (DefaultJndiBindingPolicy)policyClass.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Error in instanciating defined JNDI Binding Policy Class: " + jndiPolicyName, t);
            }
            log.debug((Object)("Using " + DefaultJndiBindingPolicy.class.getSimpleName() + " \"" + policy.getClass().getName() + "\" for Session Bean " + md.getEjbName()));
        }
        if (policy == null) {
            policy = new BasicJndiBindingPolicy();
            log.debug((Object)("Defaulting to " + DefaultJndiBindingPolicy.class.getSimpleName() + " of \"" + BasicJndiBindingPolicy.class.getName() + "\" for Session Bean " + md.getEjbName()));
        }
        return policy;
    }
}

