/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.proxy.spi;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;

public class InterceptorChainInvocationHandler
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private final Interceptor[] interceptorChain;
    private final Object target;

    public InterceptorChainInvocationHandler(Interceptor[] interceptorChain, Object target) {
        this.interceptorChain = interceptorChain;
        this.target = target;
    }

    public InterceptorChainInvocationHandler(List<Interceptor> interceptorChain, Object target) {
        this(interceptorChain.toArray(new Interceptor[0]), target);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInvocation sri = this.constructMethodInvocation(method, args);
        this.addArgumentsToInvocation(sri, args);
        return sri.invokeNext();
    }

    protected MethodInvocation constructMethodInvocation(Method method, Object[] args) {
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInvocation sri = new MethodInvocation(this.getInterceptorChain(), hash, method, method, null);
        sri.setTargetObject(this.getTarget());
        return sri;
    }

    protected void addArgumentsToInvocation(MethodInvocation invocation, Object[] originalArguments) {
        invocation.setArguments(originalArguments);
    }

    protected Interceptor[] getInterceptorChain() {
        return this.interceptorChain;
    }

    protected Object getTarget() {
        return this.target;
    }
}

