/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.registrar.plugin.mc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.ejb3.common.registrar.spi.DuplicateBindException;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;

public class Ejb3McRegistrar
implements Ejb3Registrar {
    private static final Logger log = Logger.getLogger(Ejb3McRegistrar.class);
    private Kernel kernel;

    public Ejb3McRegistrar(Kernel kernel) {
        this.setKernel(kernel);
        log.debug((Object)("Created " + Ejb3McRegistrar.class.getSimpleName() + " with backing " + Kernel.class.getSimpleName() + ": " + this.getKernel()));
    }

    @Override
    public Map<Object, Object> list() {
        Set installedContexts = this.getKernel().getController().getContextsByState(ControllerState.INSTALLED);
        if (installedContexts == null) {
            return new HashMap<Object, Object>();
        }
        ConcurrentHashMap<Object, Object> installedObjects = new ConcurrentHashMap();
        for (ControllerContext context : installedContexts) {
            Object bindName = context.getName();
            Object value = context.getTarget();
            installedObjects.put(bindName, value == null ? "[null]" : value);
        }
        installedObjects = Collections.unmodifiableMap(installedObjects);
        return installedObjects;
    }

    @Override
    public Object lookup(Object name) throws NotBoundException {
        return this.lookup(name, false, true);
    }

    @Deprecated
    public Object lookup(Object name, boolean checkInstalled) throws NotBoundException {
        return this.lookup(name, checkInstalled, false);
    }

    protected Object lookup(Object name, boolean checkInstalled, boolean checkStartedOrInstalled) {
        ControllerState state;
        ControllerContext context = this.getKernel().getController().getContext(name, null);
        if (context == null || context.getTarget() == null) {
            throw new NotBoundException("Requested value bound at name \"" + name + "\" is not bound.");
        }
        if (checkInstalled && !(state = context.getState()).equals((Object)ControllerState.INSTALLED)) {
            throw new NotBoundException("Object is bound at key " + name + ", but is not fully installed, instead of state: " + state);
        }
        if (checkStartedOrInstalled && !(state = context.getState()).equals((Object)ControllerState.START) && !state.equals((Object)ControllerState.INSTALLED)) {
            throw new NotBoundException("Object is bound at key " + name + ", but is not fully started or installed, instead of state: " + state);
        }
        Throwable error = context.getError();
        if (error != null) {
            throw new RuntimeException("Could not lookup object at name \"" + name + "\" due to an error with the underlying " + ControllerContext.class.getSimpleName(), error);
        }
        Object target = context.getTarget();
        log.debug((Object)("Returning from name \"" + name + "\": " + target));
        return target;
    }

    @Override
    public <T> T lookup(Object name, Class<T> type) throws NotBoundException {
        Object obj = this.lookup(name);
        T returned = null;
        try {
            returned = type.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Value returned from key \"" + name + "\" in Object Store was not of expected type " + type + ", but was instead " + obj.getClass().getName());
        }
        return returned;
    }

    @Override
    public void bind(Object name, Object value) throws DuplicateBindException {
        Object existing = null;
        try {
            existing = this.lookup(name);
        }
        catch (NotBoundException e) {
            this.install(name, value);
            return;
        }
        throw new DuplicateBindException("Cannot install " + value + " under name \"" + name + "\" as there is already an existing object there: " + existing);
    }

    @Override
    public void rebind(Object name, Object value) {
        boolean alreadyBound = true;
        try {
            this.lookup(name);
        }
        catch (NotBoundException nbe) {
            alreadyBound = false;
        }
        if (alreadyBound) {
            try {
                this.unbind(name);
            }
            catch (NotBoundException e) {
                throw new RuntimeException("Lookup in registry for name \"" + name + "\" has reported an object already bound, but attempt to unbind has failed with " + NotBoundException.class.getSimpleName(), e);
            }
        }
        this.install(name, value);
    }

    @Override
    public void unbind(Object name) throws NotBoundException {
        try {
            this.lookup(name, false);
        }
        catch (NotBoundException nbe) {
            throw new NotBoundException("Could not unbind object at name \"" + name + "\" as none is currently bound");
        }
        log.debug((Object)("Uninstalling bean with name \"" + name + "\"..."));
        this.getKernel().getController().uninstall(name);
        log.debug((Object)("Bean with name \"" + name + "\" uninstalled."));
    }

    public Kernel getProvider() {
        return this.getKernel();
    }

    @Override
    public Object invoke(Object name, String methodName, Object[] arguments, String[] signature) throws NotBoundException {
        try {
            this.lookup(name);
        }
        catch (NotBoundException nbe) {
            throw new NotBoundException("Could not invoke upon object at name \"" + name + "\" as none is currently bound");
        }
        try {
            log.debug((Object)("Invoking on bean with name \"" + name + "\" method " + methodName + ".(" + signature + ") with arguments " + arguments + "..."));
            Object result = this.getKernel().getBus().invoke(name, methodName, arguments, signature);
            log.debug((Object)("Invocation Result: " + result));
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error occured in invoking method \"" + methodName + "\" upon object bound at name " + name, t);
        }
    }

    private void install(Object name, Object value) {
        BeanMetaDataBuilder bmdb = BeanMetaDataBuilder.createBuilder((String)name.toString(), (String)value.getClass().getName());
        bmdb.setAccessMode(BeanAccessMode.ALL);
        try {
            this.getKernel().getController().install(bmdb.getBeanMetaData(), value);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not install at name \"" + name + "\" value " + value, e);
        }
        log.debug((Object)("Installed in " + this.getKernel().getController() + " at \"" + name + "\": " + value));
    }

    private Kernel getKernel() {
        return this.kernel;
    }

    private void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }
}

