/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.interceptor.InvocationContext;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;

public class BusinessMethodInterceptorMethodInterceptor
implements Interceptor {
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{InvocationContext.class};
    private Object interceptor;
    private Method method;

    public BusinessMethodInterceptorMethodInterceptor(Object interceptor, Method businessMethodInterceptorMethod) {
        assert (interceptor != null) : "interceptor is null";
        assert (businessMethodInterceptorMethod != null) : "businessMethodInterceptorMethod is null";
        assert (businessMethodInterceptorMethod.getReturnType() == Object.class) : "return type must be Object " + businessMethodInterceptorMethod;
        assert (Arrays.equals(businessMethodInterceptorMethod.getParameterTypes(), PARAMETER_TYPES)) : "wrong parameter signature";
        this.interceptor = interceptor;
        this.method = businessMethodInterceptorMethod;
    }

    public String getName() {
        return "BusinessMethodInterceptorMethodInterceptor";
    }

    public Class<?> getRealClass() {
        return this.interceptor.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        InvocationContextInterceptor.InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        Object[] args = new Object[]{ctx};
        boolean accessible = this.method.isAccessible();
        this.method.setAccessible(true);
        try {
            Object object = this.method.invoke(this.interceptor, args);
            this.method.setAccessible(accessible);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.method.setAccessible(accessible);
                throw throwable;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

