/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.container.LifecycleMethodInterceptorsInvocation;

public class LifecycleCallbackInterceptorMethodLazyInterceptor
implements Interceptor {
    private Method lifecycleMethod;
    private Class<?> lifecycleInterceptorClass;

    public LifecycleCallbackInterceptorMethodLazyInterceptor(Class<?> interceptorClass, Method lifecycleCallbackMethod) {
        if (interceptorClass == null || lifecycleCallbackMethod == null) {
            throw new IllegalArgumentException("Either interceptor class " + interceptorClass + " or interceptor method " + lifecycleCallbackMethod + " is null. Both are required to be non-null");
        }
        this.lifecycleInterceptorClass = interceptorClass;
        this.lifecycleMethod = lifecycleCallbackMethod;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        InvocationContextInterceptor.InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        Object[] args = new Object[]{ctx};
        boolean accessible = this.lifecycleMethod.isAccessible();
        this.lifecycleMethod.setAccessible(true);
        try {
            Object interceptorInstance = this.getInterceptorInstance(invocation);
            Object object = this.lifecycleMethod.invoke(interceptorInstance, args);
            return object;
        }
        finally {
            this.lifecycleMethod.setAccessible(accessible);
        }
    }

    protected Object getInterceptorInstance(Invocation invocation) {
        if (invocation instanceof LifecycleMethodInterceptorsInvocation) {
            LifecycleMethodInterceptorsInvocation lifecycleMethodInvocation = (LifecycleMethodInterceptorsInvocation)invocation;
            BeanContext<?> beanContext = lifecycleMethodInvocation.getBeanContext();
            return beanContext.getInterceptor(this.lifecycleInterceptorClass);
        }
        throw new IllegalStateException("Interceptor instance unavailable for invocation " + invocation);
    }
}

