/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.lang;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class ScopedClassLoader
extends URLClassLoader {
    private Set<String> exceptions = new HashSet<String>();

    public ScopedClassLoader(URL[] urls) {
        this(urls, (String[])null);
    }

    public ScopedClassLoader(URL[] urls, String[] exceptions) {
        super(urls, (ClassLoader)null);
        for (String exception : exceptions) {
            this.exceptions.add(exception);
        }
    }

    @Override
    public URL findResource(String name) {
        if (this.exceptions.contains(name)) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

