/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import java.util.Collection;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.metrics.deployer.BasicStatefulSessionInstanceMetrics;
import org.jboss.ejb3.metrics.deployer.BasicStatelessSessionInstanceMetrics;
import org.jboss.ejb3.metrics.deployer.ManagedInvocationStatisticsWrapper;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3MetricsDeployer
extends AbstractSimpleRealDeployer<Ejb3Deployment> {
    private static final Logger log = Logger.getLogger(Ejb3MetricsDeployer.class);
    public static final String NAME_OUTPUT = Ejb3MetricsDeployer.class.getName();
    private static final String BEAN_NAME_METRICS_SUFFIX = "-metrics";
    private static final String BEAN_NAME_METRICS_SUFFIX_INSTANCE = "-metrics-instance";
    private static final String BEAN_NAME_METRICS_SUFFIX_INVOCATION = "-metrics-invocation";

    public Ejb3MetricsDeployer() {
        super(Ejb3Deployment.class);
        this.addOutput(NAME_OUTPUT);
    }

    public void deploy(DeploymentUnit du, Ejb3Deployment deployment) throws DeploymentException {
        Collection containers;
        if (deployment == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping non-EJB3 Deployment: " + du));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deploying EJB3 Session metrics for : " + du));
        }
        if ((containers = deployment.getEjbContainers().values()) != null) {
            for (Container container : containers) {
                String beanName;
                Object metrics;
                if (!(container instanceof SessionContainer)) continue;
                SessionContainer sessionContainer = (SessionContainer)container;
                InvocationStatistics stats = sessionContainer.getInvokeStats();
                if (stats == null) {
                    throw new IllegalStateException("Invocation statistics was null");
                }
                ManagedInvocationStatisticsWrapper wrapper = new ManagedInvocationStatisticsWrapper(stats);
                String invocationBeanName = sessionContainer.getName() + BEAN_NAME_METRICS_SUFFIX_INVOCATION;
                this.attach(wrapper, invocationBeanName, du);
                log.debug((Object)("Attached invocation stats for: " + invocationBeanName));
                if (sessionContainer instanceof StatelessContainer) {
                    StatelessContainer slsb = (StatelessContainer)sessionContainer;
                    metrics = new BasicStatelessSessionInstanceMetrics(slsb);
                    beanName = slsb.getName() + BEAN_NAME_METRICS_SUFFIX_INSTANCE;
                    this.attach(metrics, beanName, du);
                    log.debug((Object)("Attached metrics stats for: " + beanName));
                    continue;
                }
                if (!(sessionContainer instanceof StatefulContainer)) continue;
                StatefulContainer sfsb = (StatefulContainer)sessionContainer;
                metrics = new BasicStatefulSessionInstanceMetrics(sfsb);
                beanName = sfsb.getName() + BEAN_NAME_METRICS_SUFFIX_INSTANCE;
                this.attach(metrics, beanName, du);
                log.debug((Object)("Attached metrics stats for: " + beanName));
            }
        }
        du.addAttachment(NAME_OUTPUT, (Object)true, Boolean.class);
    }

    private void attach(Object attachment, String beanName, DeploymentUnit du) throws IllegalArgumentException {
        if (attachment == null) {
            throw new IllegalArgumentException("metrics is null");
        }
        if (du == null) {
            throw new IllegalArgumentException("Deployment Unit is null");
        }
        BeanMetaDataBuilder bmdb = BeanMetaDataBuilder.createBuilder((String)beanName, (String)attachment.getClass().getName());
        bmdb.setConstructorValue((Object)new AlreadyInstantiated(attachment));
        BeanMetaData bean = bmdb.getBeanMetaData();
        du.addAttachment(beanName, (Object)bean, BeanMetaData.class);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Added metrics attachment to " + du + ": " + bean));
        }
    }

    private static class AlreadyInstantiated
    extends AbstractConstructorMetaData {
        private static final long serialVersionUID = 1L;
        private Object bean;

        public AlreadyInstantiated(Object bean) {
            this.bean = bean;
            this.setFactory((ValueMetaData)new AbstractValueMetaData((Object)new Factory()));
            this.setFactoryClass(Factory.class.getName());
            this.setFactoryMethod("create");
        }

        public class Factory {
            public Object create() {
                return AlreadyInstantiated.this.bean;
            }
        }
    }
}

