/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.metrics.deployer.ManagedSessionMetricsWrapperBase;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;

@ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT, description="Stateful Session Bean Metrics", componentType=@ManagementComponent(type="EJB3", subtype="SFSB"))
public class BasicStatefulSessionMetrics
extends ManagedSessionMetricsWrapperBase {
    private StatefulContainer sfsb;

    public BasicStatefulSessionMetrics(InvocationStatistics invocationStats, StatefulContainer sfsb) throws IllegalArgumentException {
        super((SessionContainer)sfsb, invocationStats);
        this.setSlsb(sfsb);
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The size of the SFSB instance cache for currently active sessions")
    public int getCacheSize() {
        return this.getCache().getCacheSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The total size of the SFSB instance cache, including passivated sessions")
    public int getTotalSize() {
        return this.getCache().getTotalSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of sessions currently passivated")
    public int getPassivatedCount() {
        return this.getCache().getPassivatedCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of sessions created")
    public int getCreateCount() {
        return this.getCache().getCreateCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of sessions removed")
    public int getRemoveCount() {
        return this.getCache().getRemoveCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of sessions that may be added to the current cache")
    public int getAvailableCount() {
        return this.getCache().getAvailableCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The maximum size of the SFSB instance cache")
    public int getMaxSize() {
        return this.getCache().getMaxSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of sessions currently active")
    public int getCurrentSize() {
        return this.getCache().getCurrentSize();
    }

    private StatefulCache getCache() {
        return this.getSfsb().getCache();
    }

    private StatefulContainer getSfsb() {
        return this.sfsb;
    }

    private void setSlsb(StatefulContainer sfsb) {
        this.sfsb = sfsb;
    }
}

