/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import org.jboss.ejb3.metrics.deployer.ManagedSessionMetricsWrapperBase;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;

@ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT, description="Stateless Session Bean Metrics", componentType=@ManagementComponent(type="EJB3", subtype="SLSB"))
public class BasicStatelessSessionMetrics
extends ManagedSessionMetricsWrapperBase {
    private StatelessContainer slsb;

    public BasicStatelessSessionMetrics(InvocationStatistics delegate, StatelessContainer slsb) throws IllegalArgumentException {
        super((SessionContainer)slsb, delegate);
        this.setSlsb(slsb);
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of slots available in the instance pool")
    public int getAvailableCount() {
        return this.getPool().getAvailableCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of bean instances created")
    public int getCreateCount() {
        return this.getPool().getCreateCount();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The current number of bean instances in the backing pool for this SLSB")
    public int getCurrentSize() {
        return this.getPool().getCurrentSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The maxmimum size of the backing instance pool")
    public int getMaxSize() {
        return this.getPool().getMaxSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of backing SLSB instances which have been removed")
    public int getRemoveCount() {
        return this.getPool().getRemoveCount();
    }

    private Pool getPool() {
        return this.getSlsb().getPool();
    }

    private StatelessContainer getSlsb() {
        return this.slsb;
    }

    private void setSlsb(StatelessContainer slsb) {
        this.slsb = slsb;
    }
}

