/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import org.jboss.ejb3.metrics.deployer.InvocationStatisticMetaMapper;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.annotations.MetaMapping;

public abstract class ManagedSessionMetricsWrapperBase {
    private SessionContainer container;
    private InvocationStatistics invocationStats;

    ManagedSessionMetricsWrapperBase(SessionContainer container, InvocationStatistics invocationStats) throws IllegalArgumentException {
        if (invocationStats == null) {
            throw new IllegalArgumentException("Supplied invocation stats was null");
        }
        if (container == null) {
            throw new IllegalArgumentException("Container was null");
        }
        this.setInvocationStats(invocationStats);
        this.setContainer(container);
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC})
    @MetaMapping(value=InvocationStatisticMetaMapper.class)
    public InvocationStatistics getInvocationStats() {
        return this.invocationStats;
    }

    @ManagementOperation
    public void resetInvocationStats() {
        this.invocationStats.resetStats();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC})
    public long getInvocationStatsLastResetTime() {
        return this.invocationStats.lastResetTime;
    }

    @ManagementProperty(readOnly=true, use={ViewUse.CONFIGURATION})
    public String getName() {
        return this.container.getEjbName();
    }

    abstract int getAvailableCount();

    abstract int getCreateCount();

    abstract int getCurrentSize();

    abstract int getMaxSize();

    abstract int getRemoveCount();

    private void setInvocationStats(InvocationStatistics invocationStats) {
        this.invocationStats = invocationStats;
    }

    private void setContainer(SessionContainer container) {
        this.container = container;
    }
}

