/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.ejb3.common.thread.RedirectProcessOutputToSystemOutThread;
import org.jboss.ejb3.installer.manifest.ManifestEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    private static final String SYSTEM_PROPERTY_TMP_DIRECTORY = "java.io.tmpdir";
    private static final String SYSTEM_PROPERTY_CLASS_PATH = "java.class.path";
    private static final String ENV_PROPERTY_JBOSS_HOME = "JBOSS_HOME";
    private static final String ENV_PROPERTY_ANT_HOME = "ANT_HOME";
    private static final String ENV_PROPERTY_ANT_CMD = "ANT_CMD";
    private static final String ENV_PROPERTY_INSTALL_LOCATION = "JBOSS_EJB3_PLUGIN_INSTALL_HOME";
    private static final String NAMESPACE_DIRECTORY_INSTALLER = "jbossas-ejb3-plugin-installer";
    private static final String FILENAME_LIB_DIRECTORY = "lib";
    private static final String FILENAME_CONF_DIRECTORY = "conf";
    private static final String FILENAME_JBOSSALL_CLIENT_JAR = "client/jbossall-client.jar";
    private static final String COMMAND_ANT = "ant";
    private static final String COMMAND_EXTENSION_BATCH = ".bat";
    private static final String SWITCH_ANT_BUILDFILE = "-f";
    private static final String FILENAME_BUILDFILE = "build-install-ejb3-plugin.xml";
    private static final String FILENAME_JBOSSALL_CLIENT_NEWCP_ENTRIES = "jbossas-ejb3-entries-to-add-to-jbossallclient-cp.txt";
    private static final String FILENAME_JBOSSALL_CLIENT_REMOVECP_ENTRIES = "jbossas-ejb3-entries-to-remove-from-jbossallclient-cp.txt";
    private static final String FILENAME_MANIFEST = "META-INF/MANIFEST.MF";
    private File jbossAsInstallationDirectory;
    private File installationDirectory;
    private JarFile installerJarFile;
    private File jbossallClientJarFile;
    private boolean cleanup;

    public static void main(String ... args) {
        String jbossDir = null;
        try {
            jbossDir = args[0];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new RuntimeException("Location of JBossAS Installation Directory must be first argument");
        }
        Installer installer = new Installer(jbossDir, args.length == 1);
        installer.install();
    }

    public Installer(String jbossAsInstallationDirectory, boolean cleanup) {
        this.setJbossAsInstallationDirectory(new File(jbossAsInstallationDirectory));
        this.cleanup = cleanup;
    }

    public void install() {
        this.getPrintStream().println("\n***********************************");
        this.getPrintStream().println("|| JBossAS EJB3 Plugin Installer ||");
        this.getPrintStream().println("***********************************\n");
        this.getPrintStream().println("Installing EJB3 Libraries to Temp Directory...");
        if (this.cleanup) {
            Runtime.getRuntime().addShutdownHook(new Shutdown());
        }
        this.cleanup();
        this.ensureJbossHomeExists();
        for (JarEntry library : this.getAllLibraries()) {
            this.copyFileFromJarToDirectory(this.getInstallerJarFile(), library, this.getInstallationDirectory());
        }
        for (JarEntry conf : this.getAllConfigurationFiles()) {
            this.copyFileFromJarToDirectory(this.getInstallerJarFile(), conf, this.getInstallationDirectory());
        }
        for (JarEntry pkg : this.getAllJarEntriesInDirectory("packages")) {
            this.copyFileFromJarToDirectory(this.getInstallerJarFile(), pkg, this.getInstallationDirectory());
        }
        this.copyFileFromJarToDirectory(this.getInstallerJarFile(), this.getInstallerJarFile().getJarEntry(FILENAME_BUILDFILE), this.getInstallationDirectory());
        this.patchJBossallClientJar();
        this.runAnt();
    }

    private File getJbossAsInstallationDirectory() {
        return this.jbossAsInstallationDirectory;
    }

    private void setJbossAsInstallationDirectory(File jbossAsInstallationDirectory) {
        this.jbossAsInstallationDirectory = jbossAsInstallationDirectory;
    }

    private File getInstallationDirectory() {
        if (this.installationDirectory == null) {
            File tempDir = new File(System.getProperty(SYSTEM_PROPERTY_TMP_DIRECTORY));
            File installerDir = new File(tempDir, NAMESPACE_DIRECTORY_INSTALLER);
            this.setInstallationDirectory(installerDir);
            this.getPrintStream().println("JBoss EJB3 Plugin Installation Directory: " + this.installationDirectory);
        }
        return this.installationDirectory;
    }

    private void setInstallationDirectory(File installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    private void setInstallerJarFile(JarFile installerJarFile) {
        this.installerJarFile = installerJarFile;
    }

    private JarFile getInstallerJarFile() {
        if (this.installerJarFile == null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(System.getProperty(SYSTEM_PROPERTY_CLASS_PATH));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.setInstallerJarFile(jarFile);
        }
        return this.installerJarFile;
    }

    private File getJBossallClientJarFile() {
        if (this.jbossallClientJarFile == null) {
            File jbossallClientFile = new File(this.getJbossAsInstallationDirectory(), FILENAME_JBOSSALL_CLIENT_JAR);
            if (!jbossallClientFile.exists()) {
                throw new RuntimeException("Could not find the jbossall-client JAR at: " + jbossallClientFile.getAbsolutePath());
            }
            this.getPrintStream().println("jbossall-client.jar: " + jbossallClientFile.getAbsolutePath());
            this.jbossallClientJarFile = jbossallClientFile;
        }
        return this.jbossallClientJarFile;
    }

    private void patchJBossallClientJar() {
        JarFile jbossallClientJar;
        File cpEntriesToAddFile = new File(this.getInstallationDirectory(), FILENAME_CONF_DIRECTORY + File.separatorChar + FILENAME_JBOSSALL_CLIENT_NEWCP_ENTRIES);
        if (!cpEntriesToAddFile.exists()) {
            throw new RuntimeException("Could not obtain " + cpEntriesToAddFile.getAbsolutePath());
        }
        File cpEntriesToRemoveFile = new File(this.getInstallationDirectory(), FILENAME_CONF_DIRECTORY + File.separatorChar + FILENAME_JBOSSALL_CLIENT_REMOVECP_ENTRIES);
        if (!cpEntriesToRemoveFile.exists()) {
            throw new RuntimeException("Could not obtain " + cpEntriesToRemoveFile.getAbsolutePath());
        }
        Properties cpEntriesToAddProps = new Properties();
        Properties cpEntriesToRemoveProps = new Properties();
        try {
            cpEntriesToAddProps.load(new FileInputStream(cpEntriesToAddFile));
            cpEntriesToRemoveProps.load(new FileInputStream(cpEntriesToRemoveFile));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Set<String> cpEntriesToAdd = this.setFromProperties(cpEntriesToAddProps);
        Set<String> cpEntriesToRemove = this.setFromProperties(cpEntriesToRemoveProps);
        try {
            jbossallClientJar = new JarFile(this.getJBossallClientJarFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get jbossall-client JAR file", e);
        }
        ManifestEditor editor = new ManifestEditor(jbossallClientJar);
        editor.addEntriesToClassPath(cpEntriesToAdd);
        editor.removeEntriesFromClassPath(cpEntriesToRemove);
        ZipOutputStream outStream = null;
        try {
            outStream = new JarOutputStream(new FileOutputStream(this.getJBossallClientJarFile()));
            ZipEntry manifestEntry = new ZipEntry(FILENAME_MANIFEST);
            ((JarOutputStream)outStream).putNextEntry(manifestEntry);
            Manifest manifest = jbossallClientJar.getManifest();
            manifest.write(outStream);
            outStream.closeEntry();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Set<String> setFromProperties(Properties props) {
        HashSet<String> set = new HashSet<String>();
        Enumeration<Object> names = props.keys();
        while (names.hasMoreElements()) {
            set.add((String)names.nextElement());
        }
        return set;
    }

    private List<JarEntry> getAllLibraries() {
        return this.getAllJarEntriesInDirectory(FILENAME_LIB_DIRECTORY);
    }

    private List<JarEntry> getAllConfigurationFiles() {
        return this.getAllJarEntriesInDirectory(FILENAME_CONF_DIRECTORY);
    }

    private List<JarEntry> getAllJarEntriesInDirectory(String directory) {
        ArrayList<JarEntry> libraries = new ArrayList<JarEntry>();
        JarFile jarFile = this.getInstallerJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(directory) || entry.isDirectory()) continue;
            libraries.add(entry);
        }
        return libraries;
    }

    private void runAnt() {
        try {
            Process antProcess = this.getAntProcess();
            RedirectProcessOutputToSystemOutThread captureProcess = new RedirectProcessOutputToSystemOutThread(antProcess);
            captureProcess.start();
            int exitValue = antProcess.waitFor();
            if (exitValue != 0) {
                throw new RuntimeException("Ant Process completed improperly with Exit Value " + exitValue);
            }
            this.getPrintStream().println("Ant Build Completed");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private Process getAntProcess() throws IOException {
        return this.getAntProcess(false);
    }

    private Process getAntProcess(boolean useBatchExtension) throws IOException {
        Process antProcess = null;
        String buildfile = this.getInstallationDirectory() + File.separator + FILENAME_BUILDFILE;
        String antCommandPath = System.getenv(ENV_PROPERTY_ANT_CMD);
        if (antCommandPath == null) {
            String antHome = System.getenv(ENV_PROPERTY_ANT_HOME);
            if (antHome == null || "".equals(antHome)) {
                throw new RuntimeException("Environment Variable 'ANT_HOME' must be specified.");
            }
            this.getPrintStream().println("Using ANT_HOME: " + antHome);
            antCommandPath = antHome + File.separator + "bin" + File.separator + COMMAND_ANT;
        }
        if (useBatchExtension) {
            antCommandPath = antCommandPath + COMMAND_EXTENSION_BATCH;
        }
        ProcessBuilder antProcessBuilder = new ProcessBuilder(antCommandPath, SWITCH_ANT_BUILDFILE, buildfile);
        antProcessBuilder.redirectErrorStream(true);
        antProcessBuilder.environment().put(ENV_PROPERTY_JBOSS_HOME, this.getJbossAsInstallationDirectory().getAbsolutePath());
        antProcessBuilder.environment().put(ENV_PROPERTY_INSTALL_LOCATION, this.getInstallationDirectory().getAbsolutePath());
        try {
            this.getPrintStream().println("Starting Ant> " + antCommandPath + " " + SWITCH_ANT_BUILDFILE + " " + buildfile);
            antProcess = antProcessBuilder.start();
        }
        catch (IOException ioe) {
            if (antProcess == null && useBatchExtension) {
                throw new RuntimeException("Ensure Apache Ant is properly installed and Environment Variable ANT_HOME is set", ioe);
            }
            if (antProcess == null && !useBatchExtension) {
                return this.getAntProcess(true);
            }
            throw ioe;
        }
        return antProcess;
    }

    private void cleanup() {
        this.getPrintStream().println("Starting Cleanup...");
        this.rmAndChildren(this.getInstallationDirectory());
        this.getPrintStream().println("Cleanup Complete.");
    }

    private void copyFileFromJarToDirectory(JarFile jar, JarEntry fileToCopy, File destinationDirectory) {
        BufferedInputStream in = null;
        FileOutputStream out = null;
        File destinationFile = new File(destinationDirectory, fileToCopy.getName());
        try {
            if (!destinationFile.getParentFile().exists()) {
                this.mkdirAndParents(destinationFile.getParentFile());
            }
            in = new BufferedInputStream(jar.getInputStream(fileToCopy));
            out = new FileOutputStream(destinationFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        try {
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {}
        }
        this.getPrintStream().println("Copied " + fileToCopy.getName() + " to " + destinationFile.getAbsolutePath());
    }

    private void mkdirAndParents(File directory) {
        try {
            if (!directory.mkdirs()) {
                throw new IOException("Could not make directory " + directory.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void rmAndChildren(File file) {
        if (!file.exists()) {
            return;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : file.listFiles()) {
                this.rmAndChildren(child);
            }
        }
        boolean isDir = file.isDirectory();
        boolean removed = file.delete();
        if (!(removed && isDir || removed)) {
            this.getPrintStream().println("Unable to remove " + file.getAbsolutePath());
        }
    }

    private void ensureJbossHomeExists() {
        if (!this.getJbossAsInstallationDirectory().exists()) {
            throw new RuntimeException("Specified JBoss AS Installation Directory, '" + this.getJbossAsInstallationDirectory().getAbsolutePath() + "', does not exist. ");
        }
    }

    private PrintStream getPrintStream() {
        return System.out;
    }

    private class Shutdown
    extends Thread
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            super.run();
            Installer.this.getPrintStream().println("Shutdown Hook called...");
            Installer.this.cleanup();
            Installer.this.getPrintStream().println("");
        }
    }
}

