/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.testremote.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jboss.ejb3.common.thread.RedirectProcessOutputToSystemOutThread;
import org.jboss.ejb3.testremote.server.MockServer;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServerController {
    private static Logger logger = Logger.getLogger(MockServerController.class);
    private static final String ENV_VAR_JAVAHOME = "JAVA_HOME";
    private static final String EXECUTABLE_JAVA = "bin" + File.separator + "java";
    private static final String LOCATION_BASEDIR = System.getProperty("basedir");
    private static final String LOCATION_TARGET = LOCATION_BASEDIR + File.separator + "target";
    private static final String LOCATION_TEST_CLASSES = LOCATION_TARGET + File.separator + "tests-classes";
    private static final String LOCATION_CLASSES = LOCATION_TARGET + File.separator + "classes";
    private static final String LOCATION_CONF = LOCATION_BASEDIR + File.separator + "conf";
    private static final String FILENAME_DEPENDENCY_CP = LOCATION_TARGET + File.separator + "cp.txt";
    private int serverStartupTimeout = 120000;
    private int serverStopTimeout = 120000;
    private int port;
    private String serverHost;
    private Process remoteProcess;
    private Client mockServerClient;

    public MockServerController(String host, int port) {
        this.serverHost = host;
        this.port = port;
        String uri = null;
        try {
            uri = "socket://" + this.serverHost + ":" + this.port;
            InvokerLocator invokerLocator = new InvokerLocator(uri);
            this.mockServerClient = new Client(invokerLocator);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server controller: ", e);
        }
    }

    public void startServer(Class<? extends MockServer> serverClass) throws Throwable {
        this.startServer(null, serverClass, null);
    }

    public void startServer(Class<? extends MockServer> serverClass, String[] arguments) throws Throwable {
        this.startServer(null, serverClass, arguments);
    }

    public void startServer(String envVarJavaHome, Class<? extends MockServer> serverClass) throws Throwable {
        this.startServer(envVarJavaHome, serverClass, null);
    }

    public void startServer(String envVarJavaHome, Class<? extends MockServer> serverClass, String[] arguments) throws Throwable {
        String[] processArgs = null;
        int requiredArgs = 3;
        if (arguments != null) {
            int numberOfArgs = arguments.length;
            processArgs = new String[numberOfArgs + requiredArgs];
            System.arraycopy(arguments, 0, processArgs, requiredArgs, numberOfArgs);
        } else {
            processArgs = new String[requiredArgs];
        }
        processArgs[0] = serverClass.getName();
        processArgs[1] = this.serverHost;
        processArgs[2] = String.valueOf(this.port);
        String javaHome = System.getenv(ENV_VAR_JAVAHOME);
        if (envVarJavaHome != null && envVarJavaHome.length() > 0) {
            String override = System.getenv(envVarJavaHome);
            javaHome = override != null ? override : javaHome;
        }
        this.createRemoteProcess(javaHome, serverClass, processArgs);
        long start = System.currentTimeMillis();
        int timeoutIntervalSeconds = 5;
        long timeout = (long)(timeoutIntervalSeconds * 1000) + start;
        boolean started = false;
        while (!started) {
            try {
                this.sendStartRequestToServer();
                started = true;
            }
            catch (CannotConnectException cce) {
                long current = System.currentTimeMillis();
                if (current < timeout) {
                    logger.trace((Object)("Can't connect to server @ " + new Date(current) + ", trying until " + new Date(timeout)));
                    Thread.sleep(100L);
                    continue;
                }
                logger.error((Object)"The remote process was not up, even after 5 seconds. Aborting");
                throw cce;
            }
        }
    }

    public void stopServer() throws Throwable {
        this.stopServer(true);
        logger.debug((Object)"Stopped the server and killed the remote process");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer(boolean killProcess) throws Throwable {
        if (this.remoteProcess == null) {
            logger.info((Object)"No remote process to stop. Returning");
            return;
        }
        try {
            this.sendStopRequestToServer();
            logger.debug((Object)"Stopped server");
            this.mockServerClient.disconnect();
        }
        finally {
            if (killProcess) {
                this.remoteProcess.destroy();
                logger.debug((Object)"Remote process killed");
            }
        }
    }

    public void setServerStartupTimeout(int timeout) {
        this.serverStartupTimeout = timeout;
    }

    public int getServerStartupTimeout() {
        return this.serverStartupTimeout;
    }

    public int getServerStopTimeout() {
        return this.serverStopTimeout;
    }

    public void setServerStopTimeout(int timeout) {
        this.serverStopTimeout = timeout;
    }

    protected void sendStopRequestToServer() throws Throwable {
        this.mockServerClient.connect();
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("timeout", String.valueOf(this.serverStopTimeout));
        Object serverStatus = this.mockServerClient.invoke((Object)MockServer.MockServerRequest.STOP, configParams);
        logger.debug((Object)("Stop request returned Status = " + serverStatus));
    }

    protected void sendStartRequestToServer() throws Throwable {
        this.mockServerClient.connect();
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("timeout", String.valueOf(this.serverStartupTimeout));
        Object serverStatus = this.mockServerClient.invoke((Object)MockServer.MockServerRequest.START, configParams);
        logger.info((Object)("Server started. Status = " + serverStatus));
    }

    private void createRemoteProcess(String javaHome, Class<? extends MockServer> serverClass, String[] arguments) throws Throwable {
        String conf = LOCATION_CONF;
        String testClasses = LOCATION_TEST_CLASSES;
        String classes = LOCATION_CLASSES;
        String dependencyClasspathFilename = FILENAME_DEPENDENCY_CP;
        File dependencyClasspath = new File(dependencyClasspathFilename);
        assert (dependencyClasspath.exists()) : "File " + dependencyClasspathFilename + " is required to denote the dependency CP";
        BufferedReader reader = new BufferedReader(new FileReader(dependencyClasspath));
        StringBuffer contents = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            contents.append(line);
            contents.append(System.getProperty("line.separator"));
        }
        String depCp = contents.toString().trim();
        ArrayList<String> command = new ArrayList<String>();
        StringBuffer executable = new StringBuffer();
        executable.append(javaHome);
        executable.append(File.separatorChar);
        executable.append(EXECUTABLE_JAVA);
        command.add(executable.toString());
        command.add("-classpath");
        StringBuffer classPath = new StringBuffer();
        classPath.append(classes);
        classPath.append(File.pathSeparator);
        classPath.append(testClasses);
        classPath.append(File.pathSeparatorChar);
        classPath.append(conf);
        classPath.append(File.pathSeparatorChar);
        classPath.append(depCp);
        command.add(classPath.toString());
        command.add("-ea");
        command.add(serverClass.getName());
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                command.add(arguments[i]);
            }
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        builder.redirectErrorStream(true);
        File pwd = new File(LOCATION_BASEDIR);
        assert (pwd.exists()) : "Present working directory for execution of remote process, " + pwd.getAbsolutePath() + ", could not be found.";
        logger.debug((Object)("Remote Process working directory: " + pwd.getAbsolutePath()));
        builder.directory(pwd);
        logger.info((Object)("Launching in separate process: " + this.getPrintableCommand(command)));
        try {
            this.remoteProcess = builder.start();
            logger.info((Object)("Remote process = " + this.remoteProcess));
            new RedirectProcessOutputToSystemOutThread(this.remoteProcess).start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not execute remote process", t);
        }
    }

    private String getPrintableCommand(List<String> command) {
        StringBuffer printableCmd = new StringBuffer();
        for (String cmd : command) {
            printableCmd.append(cmd);
            printableCmd.append(" ");
        }
        return printableCmd.toString();
    }
}

