/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.testremote.server;

import java.lang.reflect.Constructor;
import org.jboss.ejb3.common.registrar.plugin.mc.Ejb3McRegistrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.test.mc.bootstrap.EmbeddedTestMcBootstrap;
import org.jboss.ejb3.testremote.server.MockServerInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;

public class MockServer {
    private static final Logger log = Logger.getLogger(MockServer.class);
    private EmbeddedTestMcBootstrap bootstrap;
    private Connector remoteConnector;
    private MockServerStatus currentStatus = MockServerStatus.STOPPED;
    private String[] commandLineArgs;

    public static void main(String ... args) throws Throwable {
        if (log.isDebugEnabled()) {
            StringBuffer argList = new StringBuffer();
            for (String arg : args) {
                argList.append(arg);
                argList.append(' ');
            }
            log.debug((Object)("Arguments: " + argList));
        }
        assert (args.length >= 3) : "Parameters requried (in this order): <serverFQClassName> <serverBindAddress> <serverPort> <additionalOptionalArguments>";
        String bindHost = args[1];
        int bindPort = Integer.parseInt(args[2]);
        String mockServerClassName = args[0];
        log.debug((Object)("Creating a MockServer for serverBindAddr = " + bindHost + " and port = " + bindPort + " using " + MockServer.class.getSimpleName() + " implementation: " + mockServerClassName));
        Class<?> mockServerClass = null;
        try {
            mockServerClass = Class.forName(mockServerClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("Cannot create " + MockServer.class.getSimpleName() + " with implementation of " + mockServerClassName, e1);
        }
        assert (MockServer.class.isAssignableFrom(mockServerClass)) : "Specified implementation " + mockServerClassName + " is not of type " + MockServer.class.getName();
        Constructor<?> serverCtor = null;
        try {
            serverCtor = mockServerClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException("MockServer implementation " + mockServerClassName + " must have a public no-arg ctor", e1);
        }
        MockServer launcher = (MockServer)serverCtor.newInstance(new Object[0]);
        launcher.setCommandLineArgs(args);
        try {
            String bindUri = "socket://" + bindHost + ":" + bindPort;
            InvokerLocator invokerLocator = new InvokerLocator(bindUri);
            launcher.remoteConnector = new Connector(invokerLocator);
            launcher.remoteConnector.create();
            launcher.remoteConnector.addInvocationHandler("EJB3Test", (ServerInvocationHandler)new MockServerInvocationHandler(launcher));
            launcher.acceptRequests();
        }
        catch (Throwable e) {
            log.error((Object)"Exception in MockServer while wating for requests ", e);
            throw new RuntimeException("Exception while waiting for requests ", e);
        }
    }

    protected void initialize() throws Throwable {
        this.setBootstrap(EmbeddedTestMcBootstrap.createEmbeddedMcBootstrap());
        Ejb3RegistrarLocator.bindRegistrar((Ejb3Registrar)new Ejb3McRegistrar(this.bootstrap.getKernel()));
    }

    public void start() throws Throwable {
        if (!this.currentStatus.equals((Object)MockServerStatus.STOPPED)) {
            throw new IllegalStateException("Cannot start MockServer when its in " + (Object)((Object)this.getStatus()) + " state");
        }
        this.initialize();
        this.currentStatus = MockServerStatus.STARTED;
        log.info((Object)"MockServer started");
    }

    public void stop() {
        if (!this.currentStatus.equals((Object)MockServerStatus.STARTED)) {
            throw new IllegalStateException("Cannot stop MockServer when its in " + (Object)((Object)this.getStatus()) + " state");
        }
        this.bootstrap.shutdown();
        this.currentStatus = MockServerStatus.STOPPED;
        log.info((Object)"MockServer stopped");
    }

    public MockServerStatus getStatus() {
        return this.currentStatus;
    }

    protected void acceptRequests() throws Throwable {
        this.remoteConnector.start();
    }

    public EmbeddedTestMcBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(EmbeddedTestMcBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    protected String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    protected void setCommandLineArgs(String[] commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MockServerRequest {
        START,
        STOP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MockServerStatus {
        STARTED,
        STOPPED;

    }
}

