/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.common;

import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.ejb.EjbJar30Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionPolicyDecorator;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataHelper {
    private static final Logger log = Logger.getLogger(MetaDataHelper.class);

    public static JBossSessionBeanMetaData createMockBeanMetaData() {
        JBossMetaData metaData = new JBossMetaData();
        JBossEnterpriseBeansMetaData enterpriseBeans = new JBossEnterpriseBeansMetaData();
        metaData.setEnterpriseBeans(enterpriseBeans);
        metaData.setAssemblyDescriptor(new JBossAssemblyDescriptorMetaData());
        JBossSessionBeanMetaData sessionBeanMetaData = new JBossSessionBeanMetaData();
        sessionBeanMetaData.setEnterpriseBeansMetaData(enterpriseBeans);
        return sessionBeanMetaData;
    }

    public static JBossSessionBeanMetaData getMetadataFromBeanImplClass(Class<?> beanImplClass) {
        String home;
        String localHome;
        BusinessLocalsMetaData businessLocals;
        JBossSessionPolicyDecorator beanMetaData;
        BusinessRemotesMetaData businessRemotes;
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        HashSet classes = new HashSet();
        classes.add(beanImplClass);
        EjbJar30MetaData metaData = new EjbJar30Creator((AnnotationFinder)finder).create(classes);
        JBossMetaData mergedMetaData = new JBossMetaData();
        mergedMetaData.merge(null, (EjbJarMetaData)metaData);
        JBossSessionBeanMetaData beanMetaDataDelegate = (JBossSessionBeanMetaData)mergedMetaData.getEnterpriseBean(beanImplClass.getSimpleName());
        if (beanMetaDataDelegate.getBusinessRemotes() != null || beanMetaDataDelegate.getHome() != null) {
            ArrayList<RemoteBindingMetaData> remoteBindings = new ArrayList<RemoteBindingMetaData>();
            RemoteBindingMetaData remoteBinding = new RemoteBindingMetaData();
            remoteBinding.setClientBindUrl("socket://localhost:3874");
            remoteBindings.add(remoteBinding);
            beanMetaDataDelegate.setRemoteBindings(remoteBindings);
        }
        if ((businessRemotes = (beanMetaData = new JBossSessionPolicyDecorator(beanMetaDataDelegate)).getBusinessRemotes()) != null) {
            log.info((Object)("Business Remote JNDI Name: " + beanMetaData.determineJndiName()));
            for (String businessInterface : beanMetaData.getBusinessRemotes()) {
                log.info((Object)("Business Remote JNDI Name for " + businessInterface + ": " + beanMetaData.determineResolvedJndiName(businessInterface)));
            }
        }
        if ((businessLocals = beanMetaData.getBusinessLocals()) != null) {
            log.info((Object)("Local JNDI Name: " + beanMetaData.determineLocalJndiName()));
            for (String businessInterface : beanMetaData.getBusinessLocals()) {
                log.info((Object)("Business Local JNDI Name for " + businessInterface + ": " + beanMetaData.determineResolvedJndiName(businessInterface)));
            }
        }
        if ((localHome = beanMetaData.getLocalHome()) != null && !localHome.trim().equals("")) {
            log.info((Object)("Local Home JNDI Name: " + beanMetaData.determineResolvedJndiName(localHome)));
        }
        if ((home = beanMetaData.getHome()) != null && !home.trim().equals("")) {
            log.info((Object)("Home JNDI Name: " + beanMetaData.determineResolvedJndiName(home)));
        }
        return beanMetaData;
    }
}

