/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.mc.bootstrap;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTestMcBootstrap
extends BasicBootstrap {
    private static final Logger log = Logger.getLogger(EmbeddedTestMcBootstrap.class);
    private static final String DEFAULT_SUFFIX_DEPLOYABLE_XML = "-beans.xml";
    private BasicXMLDeployer deployer;
    private Thread shutdownHook;

    public static EmbeddedTestMcBootstrap createEmbeddedMcBootstrap() {
        EmbeddedTestMcBootstrap bootstrap = new EmbeddedTestMcBootstrap();
        log.debug((Object)("Starting " + (Object)((Object)bootstrap) + "..."));
        bootstrap.run();
        log.info((Object)("Started: " + (Object)((Object)bootstrap)));
        return bootstrap;
    }

    protected void bootstrap() throws Throwable {
        super.bootstrap();
        this.setDeployer(new BasicXMLDeployer(this.getKernel()));
        this.shutdownHook = new ShutdownDeployerThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public KernelDeployment deploy(URL url) {
        try {
            log.debug((Object)("Deploying " + url.toString() + "..."));
            KernelDeployment deployment = this.getDeployer().deploy(url);
            log.info((Object)("Deployed: " + url.toString()));
            return deployment;
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not deploy " + url.toString(), e);
        }
    }

    public void deploy(ClassLoader cl, String url) {
        Enumeration<URL> deployables = this.getResources(cl, url);
        while (deployables.hasMoreElements()) {
            URL deployable = deployables.nextElement();
            KernelDeployment deployment = this.deploy(deployable);
            try {
                this.getDeployer().validate(deployment);
            }
            catch (Throwable t) {
                throw new RuntimeException("Deployment of " + deployable + " failed", t);
            }
        }
    }

    public void deploy(Class<?> testClass) {
        this.deploy(testClass, null);
    }

    public void deploy(Class<?> testClass, String filename) {
        this.deploy(testClass.getClassLoader(), this.getDeployableXmlUrl(testClass, filename));
    }

    public <T> T lookup(String name, Class<T> expectedType) throws Throwable {
        KernelController controller = this.getKernel().getController();
        ControllerContext context = controller.getContext((Object)name, null);
        controller.change(context, ControllerState.INSTALLED);
        if (context.getError() != null) {
            throw context.getError();
        }
        if (context.getState() != ControllerState.INSTALLED) {
            log.error((Object)context.getDependencyInfo().getUnresolvedDependencies(null));
        }
        assert (context.getState() == ControllerState.INSTALLED);
        return expectedType.cast(context.getTarget());
    }

    public void undeploy(URL url) {
        try {
            log.debug((Object)("Undeploying " + url.toString() + "..."));
            this.getDeployer().undeploy(url);
            log.info((Object)("Undeployed: " + url.toString()));
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not undeploy " + url.toString(), e);
        }
    }

    public void undeploy(ClassLoader cl, String url) {
        Enumeration<URL> deployables = this.getResources(cl, url);
        while (deployables.hasMoreElements()) {
            this.undeploy(deployables.nextElement());
        }
    }

    public void undeploy(Class<?> testClass) {
        this.undeploy(testClass, null);
    }

    public void undeploy(Class<?> testClass, String filename) {
        this.undeploy(testClass.getClassLoader(), this.getDeployableXmlUrl(testClass, filename));
    }

    protected BasicXMLDeployer getDeployer() {
        return this.deployer;
    }

    protected void setDeployer(BasicXMLDeployer deployer) {
        this.deployer = deployer;
    }

    private String getDeployableXmlUrl(Class<?> clazz, String filename) {
        StringBuffer url = new StringBuffer();
        if (filename != null) {
            url.append(clazz.getClass().getPackage().toString());
            url.append('.');
            url.append(filename);
        } else {
            url.append(clazz.getName());
        }
        String flatten = url.toString();
        flatten = flatten.replace('.', '/');
        flatten = flatten + DEFAULT_SUFFIX_DEPLOYABLE_XML;
        return flatten;
    }

    private Enumeration<URL> getResources(ClassLoader cl, String resource) {
        assert (cl != null) : "Specified " + ClassLoader.class.getSimpleName() + " is null";
        assert (resource != null && !resource.equals("")) : "Resource must be specified";
        Enumeration<URL> urls = null;
        try {
            urls = cl.getResources(resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not obtain " + resource);
        }
        if (urls == null || !urls.hasMoreElements()) {
            throw new RuntimeException("Resource \"" + resource + "\" could not be obtained from current classloader");
        }
        return urls;
    }

    public void installInstance(String name, Object instance) throws Throwable {
        BeanMetaDataBuilder bmdb = BeanMetaDataBuilder.createBuilder((String)name, (String)instance.getClass().getName());
        this.getKernel().getController().install(bmdb.getBeanMetaData(), instance);
        log.info((Object)("Installed in MC at \"" + name + "\": " + instance));
    }

    public void shutdown() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.shutdownHook();
    }

    private void shutdownHook() {
        log.debug((Object)("Shutting down " + this.deployer + "..."));
        this.getDeployer().shutdown();
        log.info((Object)("Shut down: " + this.getDeployer()));
    }

    protected final class ShutdownDeployerThread
    extends Thread {
        protected ShutdownDeployerThread() {
        }

        public void run() {
            super.run();
            EmbeddedTestMcBootstrap.this.shutdownHook();
        }
    }
}

