/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.common;

import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JBossSessionPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataHelper {
    private static final Logger log = Logger.getLogger(MetaDataHelper.class);

    public static JBossSessionBeanMetaData createMockBeanMetaData() {
        JBossMetaData metaData = new JBossMetaData();
        JBossEnterpriseBeansMetaData enterpriseBeans = new JBossEnterpriseBeansMetaData();
        metaData.setEnterpriseBeans(enterpriseBeans);
        metaData.setAssemblyDescriptor(new JBossAssemblyDescriptorMetaData());
        JBossSessionBeanMetaData sessionBeanMetaData = new JBossSessionBeanMetaData();
        sessionBeanMetaData.setEnterpriseBeansMetaData(enterpriseBeans);
        return sessionBeanMetaData;
    }

    public static JBossSessionBeanMetaData getMetadataFromBeanImplClass(Class<?> beanImplClass) {
        String home;
        String localHome;
        BusinessLocalsMetaData businessLocals;
        JBossSessionPolicyDecorator beanMetaData;
        BusinessRemotesMetaData businessRemotes;
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        HashSet classes = new HashSet();
        classes.add(beanImplClass);
        JBoss50MetaData metadata = new JBoss50Creator((AnnotationFinder)finder).create(classes);
        String ejbName = beanImplClass.getSimpleName();
        JBossSessionBeanMetaData beanMetaDataDelegate = (JBossSessionBeanMetaData)metadata.getEnterpriseBean(ejbName);
        assert (beanMetaDataDelegate != null) : "Bean metadata for " + ejbName + " could not be found";
        if (!(beanMetaDataDelegate.getBusinessRemotes() == null && beanMetaDataDelegate.getHome() == null || beanMetaDataDelegate.getRemoteBindings() != null && beanMetaDataDelegate.getRemoteBindings().size() != 0)) {
            ArrayList<RemoteBindingMetaData> remoteBindings = new ArrayList<RemoteBindingMetaData>();
            RemoteBindingMetaData remoteBinding = new RemoteBindingMetaData();
            remoteBindings.add(remoteBinding);
            beanMetaDataDelegate.setRemoteBindings(remoteBindings);
        }
        if ((businessRemotes = (beanMetaData = new JBossSessionPolicyDecorator(beanMetaDataDelegate, (DefaultJndiBindingPolicy)new BasicJndiBindingPolicy())).getBusinessRemotes()) != null) {
            log.info((Object)("Business Remote JNDI Name: " + beanMetaData.getJndiName()));
            for (String businessInterface : beanMetaData.getBusinessRemotes()) {
                log.info((Object)("Business Remote JNDI Name for " + businessInterface + ": " + beanMetaData.determineResolvedJndiName(businessInterface)));
            }
        }
        if ((businessLocals = beanMetaData.getBusinessLocals()) != null) {
            log.info((Object)("Local JNDI Name: " + beanMetaData.getLocalJndiName()));
            for (String businessInterface : beanMetaData.getBusinessLocals()) {
                log.info((Object)("Business Local JNDI Name for " + businessInterface + ": " + beanMetaData.determineResolvedJndiName(businessInterface)));
            }
        }
        if ((localHome = beanMetaData.getLocalHome()) != null && !localHome.trim().equals("")) {
            log.info((Object)("Local Home JNDI Name: " + beanMetaData.determineResolvedJndiName(localHome)));
        }
        if ((home = beanMetaData.getHome()) != null && !home.trim().equals("")) {
            log.info((Object)("Home JNDI Name: " + beanMetaData.determineResolvedJndiName(home)));
        }
        return beanMetaData;
    }
}

