/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.deployer;

import java.io.Serializable;
import java.util.List;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.ejb3.EJBContainer;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class AutoTimerInitializer {
    private EJBContainer container;

    public AutoTimerInitializer() {
    }

    public AutoTimerInitializer(EJBContainer container) {
        this.container = container;
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    @Start
    public void initializeAutoTimers() {
        if (this.container == null) {
            throw new IllegalStateException("Cannot initialize auto-timers since container is not present");
        }
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = this.container.getXml();
        if (!enterpriseBeanMetaData.getJBossMetaData().isEJB31()) {
            return;
        }
        List autoTimersMetaData = null;
        if (enterpriseBeanMetaData.isSession()) {
            JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBeanMetaData;
            if (sessionBean.isStateful()) {
                return;
            }
            autoTimersMetaData = sessionBean.getTimers();
        } else if (enterpriseBeanMetaData.isMessageDriven()) {
            JBossMessageDrivenBean31MetaData mdb = (JBossMessageDrivenBean31MetaData)enterpriseBeanMetaData;
            autoTimersMetaData = mdb.getTimers();
        }
        if (autoTimersMetaData == null) {
            return;
        }
        TimerService timerService = this.container.getTimerService();
        if (!(timerService instanceof org.jboss.ejb3.timerservice.extension.TimerService)) {
            return;
        }
        org.jboss.ejb3.timerservice.extension.TimerService ejb31TimerService = (org.jboss.ejb3.timerservice.extension.TimerService)timerService;
        for (TimerMetaData autoTimerMetaData : autoTimersMetaData) {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setPersistent(autoTimerMetaData.isPersistent());
            timerConfig.setInfo((Serializable)((Object)autoTimerMetaData.getInfo()));
            String timeoutMethodName = autoTimerMetaData.getTimeoutMethod().getMethodName();
            MethodParametersMetaData methodParams = autoTimerMetaData.getTimeoutMethod().getMethodParams();
            String[] timeoutMethodParams = null;
            if (methodParams != null) {
                timeoutMethodParams = (String[])methodParams.toArray((Object[])new String[methodParams.size()]);
            }
            ejb31TimerService.getAutoTimer(autoTimerMetaData.getScheduleExpression(), timerConfig, timeoutMethodName, timeoutMethodParams);
        }
    }
}

