/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.deployer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.ejb3.EJBContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class AutoTimerInitializer {
    private static Logger logger = Logger.getLogger(AutoTimerInitializer.class);
    private EJBContainer container;

    public AutoTimerInitializer() {
    }

    public AutoTimerInitializer(EJBContainer container) {
        this.container = container;
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    @Start
    public void initializeAutoTimers() {
        if (this.container == null) {
            throw new IllegalStateException("Cannot initialize auto-timers since container is not present");
        }
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = this.container.getXml();
        if (!enterpriseBeanMetaData.getJBossMetaData().isEJB31()) {
            return;
        }
        List autoTimersMetaData = null;
        if (enterpriseBeanMetaData.isSession()) {
            JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBeanMetaData;
            if (sessionBean.isStateful()) {
                return;
            }
            autoTimersMetaData = sessionBean.getTimers();
        } else if (enterpriseBeanMetaData.isMessageDriven()) {
            JBossMessageDrivenBean31MetaData mdb = (JBossMessageDrivenBean31MetaData)enterpriseBeanMetaData;
            autoTimersMetaData = mdb.getTimers();
        }
        if (autoTimersMetaData == null) {
            return;
        }
        TimerService timerService = this.container.getTimerService();
        if (!(timerService instanceof org.jboss.ejb3.timerservice.extension.TimerService)) {
            logger.warn((Object)("Cannot create auto timers for EJB: " + enterpriseBeanMetaData.getEjbName() + " since the timerservice isn't of type " + org.jboss.ejb3.timerservice.extension.TimerService.class.getName()));
            return;
        }
        org.jboss.ejb3.timerservice.extension.TimerService ejb31TimerService = (org.jboss.ejb3.timerservice.extension.TimerService)timerService;
        for (TimerMetaData autoTimerMetaData : autoTimersMetaData) {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setPersistent(autoTimerMetaData.isPersistent());
            timerConfig.setInfo((Serializable)((Object)autoTimerMetaData.getInfo()));
            Method timeoutMethod = this.getTimeoutMethod(autoTimerMetaData.getTimeoutMethod(), this.container.getBeanClass());
            ejb31TimerService.getAutoTimer(autoTimerMetaData.getScheduleExpression(), timerConfig, timeoutMethod);
        }
    }

    private Method getTimeoutMethod(NamedMethodMetaData timeoutMethodMetaData, Class<?> beanClass) {
        Method[] methods;
        String timeoutMethodName = timeoutMethodMetaData.getMethodName();
        MethodParametersMetaData timeoutMethodParams = timeoutMethodMetaData.getMethodParams();
        Class[] timeoutMethodParamTypes = new Class[]{};
        if (timeoutMethodParams != null) {
            timeoutMethodParamTypes = new Class[timeoutMethodParams.size()];
            int i = 0;
            for (String paramClassName : timeoutMethodParams) {
                Class<?> methodParamClass = null;
                try {
                    methodParamClass = Class.forName(paramClassName, false, beanClass.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not load method param class: " + paramClassName + " of timeout method");
                }
                timeoutMethodParamTypes[i++] = methodParamClass;
            }
        }
        for (Method method : methods = beanClass.getMethods()) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(timeoutMethodName) || timeoutMethodParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) continue;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (timeoutMethodParamTypes[i].equals(methodParamTypes[i])) continue;
            }
            return method;
        }
        return null;
    }
}

