/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.deployer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.ejb.TimerConfig;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.common.lang.ClassHelper;
import org.jboss.ejb3.timerservice.extension.TimerService;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class AutoTimerInitializer {
    private static Logger logger = Logger.getLogger(AutoTimerInitializer.class);
    private EJBContainer container;

    public AutoTimerInitializer() {
    }

    public AutoTimerInitializer(EJBContainer container) {
        this.container = container;
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    @Start
    public void initializeAutoTimers() {
        if (this.container == null) {
            throw new IllegalStateException("Cannot initialize auto-timers since container is not present");
        }
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = this.container.getXml();
        if (!enterpriseBeanMetaData.getJBossMetaData().isEJB31()) {
            return;
        }
        List autoTimersMetaData = null;
        if (enterpriseBeanMetaData.isSession() && enterpriseBeanMetaData instanceof JBossSessionBean31MetaData) {
            JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBeanMetaData;
            if (sessionBean.isStateful()) {
                return;
            }
            autoTimersMetaData = sessionBean.getTimers();
        } else if (enterpriseBeanMetaData.isMessageDriven() && enterpriseBeanMetaData instanceof JBossMessageDrivenBean31MetaData) {
            JBossMessageDrivenBean31MetaData mdb = (JBossMessageDrivenBean31MetaData)enterpriseBeanMetaData;
            autoTimersMetaData = mdb.getTimers();
        }
        if (autoTimersMetaData == null) {
            return;
        }
        javax.ejb.TimerService timerService = this.container.getTimerService();
        if (!(timerService instanceof TimerService)) {
            logger.warn((Object)("Cannot create auto timers for EJB: " + enterpriseBeanMetaData.getEjbName() + " since the timerservice isn't of type " + TimerService.class.getName()));
            return;
        }
        TimerService ejb31TimerService = (TimerService)timerService;
        for (TimerMetaData autoTimerMetaData : autoTimersMetaData) {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setPersistent(autoTimerMetaData.isPersistent());
            timerConfig.setInfo((Serializable)((Object)autoTimerMetaData.getInfo()));
            NamedMethodMetaData timeoutMethodMetaData = autoTimerMetaData.getTimeoutMethod();
            Method timeoutMethod = this.getTimeoutMethod(timeoutMethodMetaData, this.container.getBeanClass());
            if (timeoutMethod == null) {
                StringBuilder methodStringBuilder = new StringBuilder();
                methodStringBuilder.append(timeoutMethodMetaData.getMethodName());
                if (timeoutMethodMetaData.getMethodParams() != null) {
                    methodStringBuilder.append(Arrays.toString(timeoutMethodMetaData.getMethodParams().toArray()));
                }
                throw new IllegalStateException("Timeout method: " + methodStringBuilder.toString() + " not found for bean class: " + enterpriseBeanMetaData.getEjbClass());
            }
            ejb31TimerService.getAutoTimer(autoTimerMetaData.getScheduleExpression(), timerConfig, timeoutMethod);
        }
    }

    private Method getTimeoutMethod(NamedMethodMetaData timeoutMethodMetaData, Class<?> beanClass) {
        String timeoutMethodName = timeoutMethodMetaData.getMethodName();
        MethodParametersMetaData timeoutMethodParams = timeoutMethodMetaData.getMethodParams();
        List probableTimeoutMethods = ClassHelper.getAllMethodsByName(beanClass, (String)timeoutMethodName);
        if (probableTimeoutMethods == null || probableTimeoutMethods.isEmpty()) {
            return null;
        }
        if (timeoutMethodParams == null) {
            if (probableTimeoutMethods.size() > 1) {
                throw new IllegalStateException("Found more than one timeout method with name: " + timeoutMethodName + " on bean " + beanClass);
            }
            return (Method)probableTimeoutMethods.get(0);
        }
        Class[] timeoutMethodParamTypes = new Class[timeoutMethodParams.size()];
        int i = 0;
        for (String paramClassName : timeoutMethodParams) {
            Class<?> methodParamClass = null;
            try {
                methodParamClass = Class.forName(paramClassName, false, beanClass.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load method param class: " + paramClassName + " of timeout method");
            }
            timeoutMethodParamTypes[i++] = methodParamClass;
        }
        for (Method method : probableTimeoutMethods) {
            Class<?>[] methodParamTypes = method.getParameterTypes();
            if (!this.equals(timeoutMethodParamTypes, methodParamTypes)) continue;
            return method;
        }
        return null;
    }

    private boolean equals(Class<?>[] params, Class<?>[] otherParams) {
        if (params.length != otherParams.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].equals(otherParams[i])) continue;
            return false;
        }
        return true;
    }
}

