/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.currentinvocation.CurrentInvocation;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.tx.AbstractInterceptor;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxUtil {
    private static final Logger log = Logger.getLogger(TxUtil.class);

    public static TransactionManager getTransactionManager() {
        return TransactionManagerLocator.getInstance().locate();
    }

    public static TransactionManagementType getTransactionManagementType(Advisor advisor) {
        TransactionManagement transactionManagement = (TransactionManagement)advisor.resolveAnnotation(TransactionManagement.class);
        if (transactionManagement == null) {
            return TransactionManagementType.CONTAINER;
        }
        return transactionManagement.value();
    }

    public static ApplicationException getApplicationException(Class<?> exceptionClass, Invocation invocation) {
        return AbstractInterceptor.resolveAnnotation(invocation, exceptionClass, ApplicationException.class);
    }

    public static boolean getRollbackOnly() {
        Invocation currentInvocation = CurrentInvocation.getCurrentInvocation();
        Advisor advisor = currentInvocation.getAdvisor();
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + advisor.getName() + ": it is illegal to call getRollbackOnly from BMT: " + type);
        }
        if (TxUtil.getTxType(currentInvocation) == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException("getRollbackOnly() not allowed with TransactionAttributeType.SUPPORTS (EJB 3 13.6.2.9)");
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            return status == 1 || status == 9 || status == 4;
        }
        catch (SystemException e) {
            log.warn((Object)"failed to get tx manager status; ignoring", (Throwable)e);
            return true;
        }
    }

    protected static TransactionAttributeType getTxType(Advisor advisor, Method method) {
        TransactionAttribute tx = (TransactionAttribute)advisor.resolveAnnotation(method, TransactionAttribute.class);
        if (tx == null) {
            tx = (TransactionAttribute)advisor.resolveAnnotation(TransactionAttribute.class);
        }
        TransactionAttributeType value = TransactionAttributeType.REQUIRED;
        if (tx != null && tx.value() != null) {
            value = tx.value();
        }
        return value;
    }

    private static TransactionAttributeType getTxType(Invocation invocation) {
        return TxUtil.getTxType(invocation.getAdvisor(), ((MethodInvocation)invocation).getActualMethod());
    }

    public static UserTransaction getUserTransaction(BeanContext<?> ctx) {
        Invocation invocation = CurrentInvocation.getCurrentInvocation();
        if (invocation == null) {
            throw new IllegalStateException("It's not allowed to get the UserTransaction during construction and injection " + ctx);
        }
        if (ctx.getInstance() != invocation.getTargetObject()) {
            throw new IllegalStateException("It's not allowed to get the UserTransaction during construction and injection " + ctx);
        }
        Advisor advisor = invocation.getAdvisor();
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.BEAN) {
            throw new IllegalStateException("Container " + advisor.getName() + ": it is illegal to inject UserTransaction into a CMT bean");
        }
        return new UserTransactionImpl();
    }

    public static void setRollbackOnly() {
        Advisor advisor = CurrentInvocation.getCurrentInvocation().getAdvisor();
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + advisor.getName() + ": it is illegal to call setRollbackOnly from BMT: " + type);
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            log.warn((Object)"failed to set rollback only; ignoring", (Throwable)e);
        }
    }
}

