/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.ejb.Stateful;
import javax.ejb.TransactionManagementType;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.ejb3.interceptors.aop.AbstractInterceptorFactory;
import org.jboss.ejb3.tx.CMTTxInterceptorFactory;
import org.jboss.ejb3.tx.NullInterceptor;
import org.jboss.ejb3.tx.StatefulBMTInterceptor;
import org.jboss.ejb3.tx.StatelessBMTInterceptor;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class BMTTxInterceptorFactory
extends AbstractInterceptorFactory {
    private static final Logger log = Logger.getLogger(CMTTxInterceptorFactory.class);

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        boolean stateful;
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.BEAN) {
            return new NullInterceptor();
        }
        TransactionManager tm = TxUtil.getTransactionManager();
        boolean bl = stateful = advisor.resolveAnnotation(Stateful.class) != null;
        if (stateful) {
            return new StatefulBMTInterceptor(tm);
        }
        return new StatelessBMTInterceptor(tm);
    }
}

