/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.jndibinding.bean;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.logging.Logger;
import org.jboss.tutorial.jndibinding.bean.Customer;
import org.jboss.tutorial.jndibinding.bean.CustomerManager;

@Stateless
@Remote(value={CustomerManager.class})
@RemoteBinding(jndiBinding="CustomerManager")
public class CustomerBean
implements CustomerManager {
    private Logger logger = Logger.getLogger(CustomerBean.class);
    private static final String ENTITY_MANAGER_JNDI_NAME = "java:/jboss-ejb3-tutorial-jndibinding-EntityManager";

    public long createCustomer(String name) {
        Customer customer = new Customer();
        customer.setName(name);
        try {
            InitialContext ctx = new InitialContext();
            EntityManager em = (EntityManager)ctx.lookup(ENTITY_MANAGER_JNDI_NAME);
            this.logger.debug((Object)("Entitymanager found in jndi: " + em));
            em.persist((Object)customer);
            this.logger.debug((Object)("Created customer named " + name + " with id " + customer.getId()));
            return customer.getId();
        }
        catch (NamingException ne) {
            this.logger.error((Object)("Could not create customer with name " + name), (Throwable)ne);
            throw new RuntimeException(ne);
        }
    }

    public Customer getCustomer(long id) {
        try {
            InitialContext ctx = new InitialContext();
            EntityManager em = (EntityManager)ctx.lookup(ENTITY_MANAGER_JNDI_NAME);
            this.logger.debug((Object)("Entitymanager found in jndi: " + em));
            return (Customer)em.find(Customer.class, (Object)id);
        }
        catch (NamingException ne) {
            this.logger.error((Object)("Could not find customer with id " + id), (Throwable)ne);
            throw new RuntimeException(ne);
        }
    }
}

