/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.nointerface.impl.jndi.AbstractNoInterfaceViewJNDIBinder;
import org.jboss.ejb3.nointerface.impl.objectfactory.StatefulNoInterfaceViewObjectFactory;
import org.jboss.ejb3.nointerface.impl.view.factory.StatefulNoInterfaceViewFacade;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class SessionAwareNoInterfaceViewJNDIBinder
extends AbstractNoInterfaceViewJNDIBinder {
    private static Logger logger = Logger.getLogger(SessionAwareNoInterfaceViewJNDIBinder.class);
    private static final String NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX = "/no-interface-stateful-proxyfactory";

    public SessionAwareNoInterfaceViewJNDIBinder(KernelControllerContext endPointCtx) {
        super(endPointCtx);
    }

    public String bindNoInterfaceView(Context jndiCtx, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) throws NamingException, IllegalStateException {
        this.ensureNoInterfaceViewExists(beanMetaData);
        StatefulNoInterfaceViewFacade statefulNoInterfaceViewFactory = new StatefulNoInterfaceViewFacade(beanClass, this.endpointContext);
        String statefulProxyFactoryJndiName = beanMetaData.getEjbName() + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX;
        NonSerializableFactory.rebind((Context)jndiCtx, (String)statefulProxyFactoryJndiName, (Object)statefulNoInterfaceViewFactory, (boolean)true);
        Reference reference = new Reference("Object factory for no-interface view for stateful bean", StatefulNoInterfaceViewObjectFactory.class.getName(), null);
        StringRefAddr refAddr = new StringRefAddr("Stateful Proxy factory for no-interface view", statefulProxyFactoryJndiName);
        reference.add(refAddr);
        String noInterfaceJndiName = this.getJNDINameResolver(beanMetaData).resolveNoInterfaceJNDIName(beanMetaData);
        this.prettyPrintJNDIBindingInfo(beanMetaData, noInterfaceJndiName);
        Util.bind((Context)jndiCtx, (String)noInterfaceJndiName, (Object)reference);
        return noInterfaceJndiName;
    }

    public void unbindNoInterfaceView(Context jndiCtx, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) throws NamingException, IllegalStateException {
        this.ensureNoInterfaceViewExists(beanMetaData);
        String noInterfaceJndiName = this.getJNDINameResolver(beanMetaData).resolveNoInterfaceJNDIName(beanMetaData);
        jndiCtx.unbind(noInterfaceJndiName);
        jndiCtx.unbind(beanMetaData.getEjbName() + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX);
    }
}

