/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import java.lang.reflect.InvocationHandler;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.proxy.impl.remoting.ProxyRemotingUtils;
import org.jboss.ejb3.proxy.reflect.ReflectProxyFactory;
import org.jboss.ejb3.singleton.deployer.JNDIBinderImpl;
import org.jboss.ejb3.singleton.proxy.impl.invocationhandler.SingletonBeanLocalInvocationHandler;
import org.jboss.ejb3.singleton.proxy.impl.invocationhandler.SingletonBeanRemoteInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.LocalBindingMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;

public class SingletonBeanJNDIBinderDeployer
extends AbstractRealDeployerWithInput<EJBContainer>
implements DeploymentVisitor<EJBContainer> {
    private static final String REMOTE_CLIENT_INTERCEPTOR_STACK_NAME = "SingletonSessionClientInterceptors";
    private static final String LOCAL_CLIENT_INTERCEPTOR_STACK_NAME = "LocalClientInterceptors";
    private static Logger logger = Logger.getLogger(SingletonBeanJNDIBinderDeployer.class);
    private static final String JNDI_BINDER_MC_BEAN_PREFIX = "jndibinder:";

    public SingletonBeanJNDIBinderDeployer() {
        this.setDeploymentVisitor(this);
        this.setAllInputs(true);
        this.setInput(EJBContainer.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, EJBContainer container) throws DeploymentException {
        JBossEnterpriseBeanMetaData enterpriseBean = container.getXml();
        if (!enterpriseBean.isSession()) {
            return;
        }
        JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
        if (!(sessionBean instanceof JBossSessionBean31MetaData)) {
            return;
        }
        JBossSessionBean31MetaData sessionBean31 = (JBossSessionBean31MetaData)sessionBean;
        if (!sessionBean31.isSingleton()) {
            return;
        }
        this.process(unit, sessionBean31, container);
    }

    public Class<EJBContainer> getVisitorType() {
        return EJBContainer.class;
    }

    public void undeploy(DeploymentUnit unit, EJBContainer deployment) {
    }

    private void process(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        this.processRemoteBusinessInterfaces(unit, sessionBean, container);
        this.processLocalBusinessInterfaces(unit, sessionBean, container);
    }

    private void processRemoteBusinessInterfaces(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        BusinessRemotesMetaData businessRemotes = sessionBean.getBusinessRemotes();
        if (businessRemotes == null || businessRemotes.size() == 0) {
            return;
        }
        String defaultInvokerLocatorURL = ProxyRemotingUtils.getDefaultClientBinding();
        DefaultJndiBindingPolicy jndibindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndibindingPolicy);
        String containerRegistryKey = container.getObjectName().getCanonicalName();
        String containerGUID = Ejb3Registry.guid((Container)container);
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("Could not create jndi context for jndi binders", ne);
        }
        ReflectProxyFactory proxyFactory = new ReflectProxyFactory();
        Interceptor[] clientInterceptors = this.getRemoteClientInterceptors(container);
        HashSet allRemoteinterfaces = new HashSet();
        for (String businessRemote : businessRemotes) {
            try {
                Class<?> businessRemoteIntf = unit.getClassLoader().loadClass(businessRemote);
                allRemoteinterfaces.add(businessRemoteIntf);
                SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, defaultInvokerLocatorURL, clientInterceptors, businessRemote);
                Object proxy = proxyFactory.createProxy(new Class[]{businessRemoteIntf}, (InvocationHandler)invocationHandler);
                String jndiName = jndiNameResolver.resolveJNDIName((JBossSessionBeanMetaData)sessionBean, businessRemote);
                JNDIBinderImpl jndiBinder = new JNDIBinderImpl(jndiCtx, jndiName, proxy);
                String binderMCBeanName = JNDI_BINDER_MC_BEAN_PREFIX + jndiName;
                BeanMetaData jndiBinderBMD = this.createBeanMetaData(binderMCBeanName, jndiBinder, container);
                DeploymentUnit parentUnit = unit.getParent();
                parentUnit.addAttachment(BeanMetaData.class + ":" + binderMCBeanName, (Object)jndiBinderBMD);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load business remote interface " + businessRemote, cnfe);
            }
        }
        List remoteBindings = sessionBean.getRemoteBindings();
        if (remoteBindings == null || remoteBindings.isEmpty()) {
            SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, defaultInvokerLocatorURL, clientInterceptors);
            String defaultRemoteJNDIName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
            Object proxy = proxyFactory.createProxy(allRemoteinterfaces.toArray(new Class[allRemoteinterfaces.size()]), (InvocationHandler)invocationHandler);
            JNDIBinderImpl jndiBinder = new JNDIBinderImpl(jndiCtx, defaultRemoteJNDIName, proxy);
            String binderMCBeanName = JNDI_BINDER_MC_BEAN_PREFIX + defaultRemoteJNDIName;
            BeanMetaData jndiBinderBMD = this.createBeanMetaData(binderMCBeanName, jndiBinder, container);
            DeploymentUnit parentUnit = unit.getParent();
            parentUnit.addAttachment(BeanMetaData.class + ":" + binderMCBeanName, (Object)jndiBinderBMD);
        } else {
            for (RemoteBindingMetaData remoteBinding : remoteBindings) {
                String jndiName = remoteBinding.getJndiName();
                if (jndiName == null) {
                    jndiName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
                }
                String invokerLocatorURL = this.getClientBindURL(remoteBinding);
                SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, invokerLocatorURL, clientInterceptors);
                Object proxy = proxyFactory.createProxy(allRemoteinterfaces.toArray(new Class[allRemoteinterfaces.size()]), (InvocationHandler)invocationHandler);
                JNDIBinderImpl jndiBinder = new JNDIBinderImpl(jndiCtx, jndiName, proxy);
                String binderMCBeanName = JNDI_BINDER_MC_BEAN_PREFIX + jndiName;
                BeanMetaData jndiBinderBMD = this.createBeanMetaData(binderMCBeanName, jndiBinder, container);
                DeploymentUnit parentUnit = unit.getParent();
                parentUnit.addAttachment(BeanMetaData.class + ":" + binderMCBeanName, (Object)jndiBinderBMD);
            }
        }
    }

    private void processLocalBusinessInterfaces(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        DeploymentUnit parentUnit;
        BeanMetaData jndiBinderBMD;
        String binderMCBeanName;
        JNDIBinderImpl jndiBinder;
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals == null || businessLocals.size() == 0) {
            return;
        }
        DefaultJndiBindingPolicy jndibindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndibindingPolicy);
        String containerRegistryKey = container.getObjectName().getCanonicalName();
        String containerGUID = Ejb3Registry.guid((Container)container);
        ReflectProxyFactory proxyFactory = new ReflectProxyFactory();
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("Could not create jndi context for jndi binders", ne);
        }
        HashSet allLocalinterfaces = new HashSet();
        Interceptor[] clientInterceptors = this.getLocalClientInterceptors(container);
        for (String businessLocal : businessLocals) {
            Class<?> businessLocalIntf = null;
            try {
                businessLocalIntf = unit.getClassLoader().loadClass(businessLocal);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load business local interface " + businessLocal, cnfe);
            }
            allLocalinterfaces.add(businessLocalIntf);
            SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, businessLocal, clientInterceptors);
            Object proxy = proxyFactory.createProxy(new Class[]{businessLocalIntf}, (InvocationHandler)invocationHandler);
            String jndiName = jndiNameResolver.resolveJNDIName((JBossSessionBeanMetaData)sessionBean, businessLocal);
            jndiBinder = new JNDIBinderImpl(jndiCtx, jndiName, proxy);
            binderMCBeanName = JNDI_BINDER_MC_BEAN_PREFIX + jndiName;
            jndiBinderBMD = this.createBeanMetaData(binderMCBeanName, jndiBinder, container);
            parentUnit = unit.getParent();
            parentUnit.addAttachment(BeanMetaData.class + ":" + binderMCBeanName, (Object)jndiBinderBMD);
        }
        List localBindings = sessionBean.getLocalBindings();
        if (localBindings == null || localBindings.isEmpty()) {
            SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, containerGUID, clientInterceptors);
            String defaultBusinessLocalJNDIName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
            Object proxy = proxyFactory.createProxy(allLocalinterfaces.toArray(new Class[allLocalinterfaces.size()]), (InvocationHandler)invocationHandler);
            JNDIBinderImpl jndiBinder2 = new JNDIBinderImpl(jndiCtx, defaultBusinessLocalJNDIName, proxy);
            String binderMCBeanName2 = JNDI_BINDER_MC_BEAN_PREFIX + defaultBusinessLocalJNDIName;
            BeanMetaData jndiBinderBMD2 = this.createBeanMetaData(binderMCBeanName2, jndiBinder2, container);
            DeploymentUnit parentUnit2 = unit.getParent();
            parentUnit2.addAttachment(BeanMetaData.class + ":" + binderMCBeanName2, (Object)jndiBinderBMD2);
        } else {
            for (LocalBindingMetaData localBinding : localBindings) {
                String jndiName = localBinding.getJndiName();
                if (jndiName == null) {
                    jndiName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
                }
                SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, containerGUID, clientInterceptors);
                Object proxy = proxyFactory.createProxy(allLocalinterfaces.toArray(new Class[allLocalinterfaces.size()]), (InvocationHandler)invocationHandler);
                jndiBinder = new JNDIBinderImpl(jndiCtx, jndiName, proxy);
                binderMCBeanName = JNDI_BINDER_MC_BEAN_PREFIX + jndiName;
                jndiBinderBMD = this.createBeanMetaData(binderMCBeanName, jndiBinder, container);
                parentUnit = unit.getParent();
                parentUnit.addAttachment(BeanMetaData.class + ":" + binderMCBeanName, (Object)jndiBinderBMD);
            }
        }
    }

    private String getClientBindURL(RemoteBindingMetaData remoteBinding) {
        String explicitClientBindURL;
        String invokerName = remoteBinding.getInvokerName();
        String generatedClientBindURL = null;
        if (invokerName != null && !invokerName.trim().isEmpty()) {
            invokerName = invokerName.trim();
            generatedClientBindURL = ProxyRemotingUtils.getClientBinding((String)invokerName);
        }
        if ((explicitClientBindURL = remoteBinding.getClientBindUrl()) != null && explicitClientBindURL.trim().isEmpty()) {
            explicitClientBindURL = null;
        }
        if (explicitClientBindURL != null && generatedClientBindURL != null) {
            logger.warn((Object)("Both invokerName and clientBindURL specified on RemoteBinding. Ignoring the explicitly specified bind url " + explicitClientBindURL + " and instead using " + generatedClientBindURL));
        }
        String bindURL = generatedClientBindURL == null ? explicitClientBindURL : generatedClientBindURL;
        return bindURL == null ? ProxyRemotingUtils.getDefaultClientBinding() : bindURL;
    }

    private BeanMetaData createBeanMetaData(String jndiBinderName, JNDIBinderImpl jndiBinder, EJBContainer container) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)jndiBinderName, (String)jndiBinder.getClass().getName());
        builder.setConstructorValue((Object)jndiBinder);
        String containerName = container.getXml().getContainerName();
        builder.addDemand((Object)containerName, ControllerState.START, ControllerState.START, null);
        return builder.getBeanMetaData();
    }

    private Interceptor[] getRemoteClientInterceptors(EJBContainer container) {
        AspectManager manager = AspectManager.instance();
        AdviceStack stack = manager.getAdviceStack(REMOTE_CLIENT_INTERCEPTOR_STACK_NAME);
        if (stack == null) {
            throw new RuntimeException("Could not find Advice Stack with name: SingletonSessionClientInterceptors");
        }
        Interceptor[] interceptors = stack.createInterceptors(container.getAdvisor(), null);
        return interceptors;
    }

    private Interceptor[] getLocalClientInterceptors(EJBContainer container) {
        AspectManager manager = AspectManager.instance();
        AdviceStack stack = manager.getAdviceStack(LOCAL_CLIENT_INTERCEPTOR_STACK_NAME);
        if (stack == null) {
            throw new RuntimeException("Could not find Advice Stack with name: LocalClientInterceptors");
        }
        Interceptor[] interceptors = stack.createInterceptors(container.getAdvisor(), null);
        return interceptors;
    }
}

