/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.async.spi.AttachmentNames;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.ejb3.singleton.aop.impl.AOPBasedSingletonContainer;
import org.jboss.ejb3.singleton.impl.resolver.EjbLinkResolver;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class SingletonContainerDeployer
extends AbstractRealDeployerWithInput<JBossEnterpriseBeanMetaData>
implements DeploymentVisitor<JBossEnterpriseBeanMetaData> {
    private static Logger logger = Logger.getLogger(SingletonContainerDeployer.class);
    private MessageDestinationReferenceResolver messageDestinationResolver;
    private EjbReferenceResolver ejbReferenceResolver;
    private PersistenceUnitDependencyResolver puResolver;
    private JavaEEComponentInformer javaeeComponentInformer;
    protected Map<String, Container> singletonContainers = new HashMap<String, Container>();

    public SingletonContainerDeployer() {
        this.setDeploymentVisitor(this);
        this.setInput(JBossEnterpriseBeanMetaData.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
        this.addOutput(EJBContainer.class);
        this.addInput(org.jboss.ejb3.common.deployers.spi.AttachmentNames.PROCESSED_METADATA);
        this.addInput(AttachmentNames.ASYNC_INVOCATION_PROCESSOR);
    }

    public void deploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMetaData) throws DeploymentException {
        AOPBasedSingletonContainer singletonContainer;
        if (!this.isSingletonBean(beanMetaData)) {
            return;
        }
        ExecutorService asyncExecutorService = (ExecutorService)unit.getAttachment(AttachmentNames.ASYNC_INVOCATION_PROCESSOR);
        if (asyncExecutorService == null) {
            throw new IllegalStateException("No async executor available for deployment unit " + unit);
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)beanMetaData;
        ClassLoader classLoader = unit.getClassLoader();
        String domainName = AOPBasedSingletonContainer.getAOPDomainName();
        DomainDefinition singletonContainerAOPDomain = AspectManager.instance().getContainer(domainName);
        if (singletonContainerAOPDomain == null) {
            throw new DeploymentException(domainName + " AOP domain not configured - cannot deploy EJB named " + beanMetaData.getEjbName() + " in unit " + unit);
        }
        Hashtable ctxProperties = new Hashtable();
        try {
            singletonContainer = new AOPBasedSingletonContainer(classLoader, sessionBean.getEjbClass(), sessionBean.getEjbName(), (Domain)singletonContainerAOPDomain.getManager(), ctxProperties, sessionBean, unit, asyncExecutorService);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException((Throwable)cnfe);
        }
        singletonContainer.setEjbReferenceResolver(this.ejbReferenceResolver);
        singletonContainer.setMessageDestinationResolver(this.messageDestinationResolver);
        singletonContainer.setPersistenceUnitResolver(this.puResolver);
        singletonContainer.instantiated();
        singletonContainer.processMetadata();
        this.registerContainer(sessionBean.getContainerName(), (Container)singletonContainer);
        this.installContainer(unit, singletonContainer.getObjectName().getCanonicalName(), singletonContainer);
    }

    public void undeploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData enterpriseBean) {
        if (this.isSingletonBean(enterpriseBean)) {
            String containerName = enterpriseBean.getContainerName();
            this.unregisterContainer(containerName);
        }
    }

    public Class<JBossEnterpriseBeanMetaData> getVisitorType() {
        return JBossEnterpriseBeanMetaData.class;
    }

    private boolean isSingletonBean(JBossEnterpriseBeanMetaData beanMetaData) {
        if (!beanMetaData.getJBossMetaData().isEJB31()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a EJB3.1 bean " + beanMetaData.getName()));
            }
            return false;
        }
        if (!beanMetaData.isSession()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a session bean " + beanMetaData.getName()));
            }
            return false;
        }
        if (!(beanMetaData instanceof JBossSessionBean31MetaData)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Session bean " + beanMetaData.getName() + " is not of type " + JBossSessionBean31MetaData.class));
            }
            return false;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)beanMetaData;
        if (!sessionBean.isSingleton()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a singleton bean " + sessionBean.getName()));
            }
            return false;
        }
        return true;
    }

    private void registerContainer(String containerName, Container container) {
        Ejb3Registry.register((Container)container);
        this.singletonContainers.put(containerName, container);
    }

    private void unregisterContainer(String containerName) {
        Container container = this.singletonContainers.remove(containerName);
        if (container != null) {
            Ejb3Registry.unregister((Container)container);
        }
    }

    private void installContainer(DeploymentUnit unit, String containerMCBeanName, AOPBasedSingletonContainer container) {
        BeanMetaDataBuilder containerBMDBuilder = BeanMetaDataBuilder.createBuilder((String)containerMCBeanName, (String)container.getClass().getName());
        containerBMDBuilder.setConstructorValue((Object)container);
        DependencyPolicy containerDependencyPolicy = container.getDependencyPolicy();
        JBossSessionBean31MetaData sessionBeanMetaData = (JBossSessionBean31MetaData)container.getMetaData();
        String[] dependsOn = sessionBeanMetaData.getDependsOn();
        if (dependsOn != null) {
            EjbLinkResolver ejbLinkResolver = new EjbLinkResolver();
            for (String dependency : dependsOn) {
                JBossEnterpriseBeanMetaData dependencyBean = ejbLinkResolver.resolveEJB(dependency, unit);
                if (dependencyBean == null) {
                    throw new RuntimeException("Could not resolve bean for @DependsOn/depends-on with ejb-name: " + dependency + " while processing EJB named " + container.getEJBName());
                }
                if (!this.isSingletonBean(dependencyBean)) {
                    throw new RuntimeException("@DependsOn/depends-on can only refer to Singleton beans. " + dependencyBean.getEjbClass() + " is not a singleton bean");
                }
                List<String> jndiNames = this.getExposedJNDINames((JBossSessionBean31MetaData)dependencyBean);
                for (String jndiName : jndiNames) {
                    containerDependencyPolicy.addDependency("jndi:" + jndiName);
                }
                String dependencyBeanContainerName = dependencyBean.getContainerName();
                containerDependencyPolicy.addDependency(dependencyBeanContainerName);
            }
        }
        logger.debug((Object)("Installing container for EJB " + container.getEJBName()));
        if (containerDependencyPolicy instanceof MCDependencyPolicy) {
            Set supplies;
            Set demands;
            MCDependencyPolicy policy = (MCDependencyPolicy)containerDependencyPolicy;
            Set dependencies = policy.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                logger.debug((Object)"with dependencies: ");
                for (DependencyMetaData dependency : dependencies) {
                    logger.debug(dependency.getDependency());
                    containerBMDBuilder.addDependency(dependency.getDependency());
                }
            }
            if ((demands = policy.getDemands()) != null && !demands.isEmpty()) {
                logger.debug((Object)"with demands: ");
                for (DemandMetaData demand : demands) {
                    logger.debug(demand.getDemand());
                    containerBMDBuilder.addDemand(demand.getDemand());
                }
            }
            if ((supplies = policy.getSupplies()) != null && !supplies.isEmpty()) {
                logger.debug((Object)"with supplies: ");
                for (SupplyMetaData supply : supplies) {
                    logger.debug(supply.getSupply());
                    containerBMDBuilder.addSupply(supply.getSupply());
                }
            }
        }
        String javaCompMCBeanName = this.getJavaEEComponentMCBeanName(unit);
        AbstractInjectionValueMetaData javaCompInjectMetaData = new AbstractInjectionValueMetaData((Object)javaCompMCBeanName);
        containerBMDBuilder.addPropertyMetaData("javaComp", (ValueMetaData)javaCompInjectMetaData);
        DeploymentUnit parentUnit = unit.getParent();
        parentUnit.addAttachment(BeanMetaData.class + ":" + containerMCBeanName, (Object)containerBMDBuilder.getBeanMetaData());
        unit.addAttachment(EJBContainer.class + ":" + containerMCBeanName, (Object)container);
    }

    private String getJavaEEComponentMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.javaeeComponentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.javaeeComponentInformer.getModulePath(deploymentUnit);
        String componentName = this.javaeeComponentInformer.getComponentName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (componentName != null) {
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    @Inject
    public void setPersistenceUnitResolver(PersistenceUnitDependencyResolver puResolver) {
        this.puResolver = puResolver;
    }

    @Inject
    public void setMessageDestinationResolver(MessageDestinationReferenceResolver messageDestResolver) {
        this.messageDestinationResolver = messageDestResolver;
    }

    @Inject
    public void setEjbRefResolver(EjbReferenceResolver ejbRefResolver) {
        this.ejbReferenceResolver = ejbRefResolver;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }

    private List<String> getExposedJNDINames(JBossSessionBean31MetaData sessionBean) {
        String noInterfaceJNDIName;
        String defaultRemoteJNDIName;
        String defaultLocalJNDIName;
        boolean hasRemoteBusinessView;
        ArrayList<String> jndiNames = new ArrayList<String>();
        DefaultJndiBindingPolicy jndiPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndiPolicy);
        BusinessRemotesMetaData businessRemotes = sessionBean.getBusinessRemotes();
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        boolean hasLocalBusinessView = businessLocals != null && businessLocals.size() > 0;
        boolean bl = hasRemoteBusinessView = businessRemotes != null && businessRemotes.size() > 0;
        if (hasLocalBusinessView && (defaultLocalJNDIName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean)) != null) {
            jndiNames.add(defaultLocalJNDIName);
        }
        if (hasRemoteBusinessView && (defaultRemoteJNDIName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean)) != null) {
            jndiNames.add(defaultRemoteJNDIName);
        }
        if (sessionBean.isNoInterfaceBean() && (noInterfaceJNDIName = jndiNameResolver.resolveNoInterfaceJNDIName(sessionBean)) != null) {
            jndiNames.add(noInterfaceJNDIName);
        }
        return jndiNames;
    }
}

