/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.MixedValueTypeExpression;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class DayOfMonth
extends MixedValueTypeExpression {
    public static final Integer MAX_DAY_OF_MONTH = 31;
    public static final Integer MIN_DAY_OF_MONTH = -7;
    private static final Map<String, Integer> DAY_OF_MONTH_ALIAS = new HashMap<String, Integer>();
    private SortedSet<Integer> daysOfMonth = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public DayOfMonth(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> days = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                days = this.processRangeValue(range);
                this.daysOfMonth.addAll(days);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                days = this.processListValue(list);
                this.daysOfMonth.addAll(days);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer day = this.processSingleValue(singleValue);
                this.daysOfMonth.add(day);
                break;
            }
            case WILDCARD: {
                break;
            }
            case INCREMENT: {
                throw new IllegalArgumentException("Increment type expression is not allowed for day-of-month value. Invalid value: " + value);
            }
            default: {
                throw new IllegalArgumentException("Invalid value for day of month: " + value);
            }
        }
    }

    @Override
    protected Map<String, Integer> getAliases() {
        return DAY_OF_MONTH_ALIAS;
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_DAY_OF_MONTH;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_DAY_OF_MONTH;
    }

    public Calendar getNextDayOfMonth(Calendar current) {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        next.setFirstDayOfWeek(current.getFirstDayOfWeek());
        Integer currentDayOfMonth = current.get(5);
        Integer nextDayOfMonth = this.daysOfMonth.first();
        for (Integer dayOfMonth : this.daysOfMonth) {
            if (currentDayOfMonth.equals(dayOfMonth)) {
                nextDayOfMonth = currentDayOfMonth;
                break;
            }
            if (dayOfMonth <= currentDayOfMonth) continue;
            nextDayOfMonth = dayOfMonth;
            break;
        }
        if (nextDayOfMonth < currentDayOfMonth) {
            ((Calendar)next).add(2, 1);
        }
        int maximumPossibleDateForTheMonth = ((Calendar)next).getActualMaximum(5);
        while (nextDayOfMonth > maximumPossibleDateForTheMonth) {
            ((Calendar)next).add(2, 1);
            maximumPossibleDateForTheMonth = ((Calendar)next).getActualMaximum(5);
        }
        next.set(5, nextDayOfMonth);
        return next;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(5);
        }
        return this.daysOfMonth.first();
    }

    static {
        DAY_OF_MONTH_ALIAS.put("1st", 1);
        DAY_OF_MONTH_ALIAS.put("2nd", 2);
        DAY_OF_MONTH_ALIAS.put("3rd", 3);
        DAY_OF_MONTH_ALIAS.put("4th", 4);
        DAY_OF_MONTH_ALIAS.put("5th", 5);
        DAY_OF_MONTH_ALIAS.put("Last", 31);
        DAY_OF_MONTH_ALIAS.put("Sun", 1);
        DAY_OF_MONTH_ALIAS.put("Mon", 2);
        DAY_OF_MONTH_ALIAS.put("Tue", 3);
        DAY_OF_MONTH_ALIAS.put("Wed", 4);
        DAY_OF_MONTH_ALIAS.put("Thu", 5);
        DAY_OF_MONTH_ALIAS.put("Fri", 6);
        DAY_OF_MONTH_ALIAS.put("Sat", 7);
    }
}

